<?php     
	$image_hotspots_settings = [
		'anim'        => $settings['image_hotspots_anim'],
		'animDur'     => !empty($settings['image_hotspots_anim_dur']) ? $settings['image_hotspots_anim_dur'] : 350,
		'delay'       => !empty($settings['image_hotspots_anim_delay']) ? $settings['image_hotspots_anim_delay'] : 10,
		'arrow'       => ($settings['image_hotspots_arrow'] == 'yes') ? true : false,
		'distance'    => !empty($settings['image_hotspots_tooltips_distance_position']) ? $settings['image_hotspots_tooltips_distance_position'] : 6,
		'minWidth'    => !empty($settings['image_hotspots_min_width']['size']) ? $settings['image_hotspots_min_width']['size'] : 0,
		'maxWidth'    => !empty($settings['image_hotspots_max_width']['size']) ? $settings['image_hotspots_max_width']['size'] : 'null',
		'side'        => !empty($settings['image_hotspots_tooltips_position']) ? $settings['image_hotspots_tooltips_position'] : array(
			'right',
			'left'
		),
		'hideMobiles' => ($settings['image_hotspots_hide'] == true) ? true : false,
		'trigger'     => $settings['image_hotspots_trigger_type'],
		'id'          => $this->get_id()
	];
	?>
	<div class="bwp-hotspots <?php echo esc_attr($settings['layout']); ?>">
		<div class="container">
			<div class="row">
				<div class="col-lg-5 col-md-4 col-sm-12 col-xs-12">
					<?php if ($settings['image_hotspots_infomation_show'] == 'yes'): ?>
						<div class="bwp-image-hotspots-accordion">
							<div class="bwp-image-hotspots-accordion-inner">
								<div class="elementor-accordion scrollbar-inner" role="tablist">
									<?php
									foreach ($settings['image_hotspots_icons'] as $index => $item) :
										$tab_count = $index + 1;

										$tab_title_setting_key = $this->get_repeater_setting_key('image_hotspots_tooltips_texts', 'image_hotspots_icons', $index);

										$tab_content_setting_key = $this->get_repeater_setting_key('image_hotspots_tooltips_info', 'image_hotspots_icons', $index);

										$this->add_render_attribute($tab_title_setting_key, [
											'id'            => 'elementor-tab-title-' . $item['_id'],
											'class'         => ['elementor-tab-title'],
											'tabindex'      => $tab_count,
											'data-tab'      => $tab_count,
											'role'          => 'tab',
											'aria-controls' => 'elementor-tab-content-' . $item['_id'],
										]);

										$this->add_render_attribute($tab_content_setting_key, [
											'id'              => 'elementor-tab-content-' . $item['_id'],
											'class'           => ['elementor-tab-content', 'elementor-clearfix'],
											'data-tab'        => $tab_count,
											'role'            => 'tabpanel',
											'aria-labelledby' => 'elementor-tab-title-' . $item['_id'],
										]);

										$this->add_inline_editing_attributes($tab_content_setting_key, 'advanced');
										?>
										<div class="elementor-accordion-item">
											<div <?php echo $this->get_render_attribute_string($tab_title_setting_key); ?>>
												<?php echo $item['image_hotspots_tooltips_texts']; ?>
											</div>
											<div <?php echo $this->get_render_attribute_string($tab_content_setting_key); ?>><?php echo $this->parse_text_editor($item['image_hotspots_tooltips_info']); ?></div>
										</div>
									<?php endforeach; ?>
								</div>
							</div>
						</div>
					<?php endif; ?>
				</div>
				<div class="col-lg-7 col-md-8 col-sm-12 col-xs-12">
					<div id="bwp-image-hotspots-<?php echo esc_attr($this->get_id()); ?>"
						 class="bwp-image-hotspots-container"
						 data-settings='<?php echo wp_json_encode($image_hotspots_settings); ?>'>
						<img class="bwp-addons-image-hotspots-ib-img" alt="<?php echo esc_attr__('Background','wpbingo'); ?>" src="<?php echo esc_url($image_src_size); ?>">
						<?php foreach ($settings['image_hotspots_icons'] as $index => $item) {
							$list_item_key = 'img_hotspot_' . $index;
							$this->add_render_attribute($list_item_key, 'class',
								[
									$animation_class,
									'bwp-image-hotspots-main-icons',
									'elementor-repeater-item-' . $item['_id'],
									'tooltip-wrapper',
									'bwp-image-hotspots-main-icons-' . $item['_id']
								]);
							$this->add_render_attribute($list_item_key, 'data-tab', '#elementor-tab-title-' . $item['_id']);
							?>
							<div <?php echo $this->get_render_attribute_string($list_item_key); ?>
									data-tooltip-content=".tooltip_content">
								<?php
								$link_type = $item['image_hotspots_link_type'];
								if ($link_type == 'url') {
									$link_url = $item['image_hotspots_url']['url'];
								} elseif ($link_type == 'link') {
									$link_url = get_permalink($item['image_hotspots_existing_page']);
								}
								if ($item['image_hotspots_link_switcher'] == 'yes' && $settings['image_hotspots_trigger_type'] == 'hover') :
									?>
									<a class="bwp-image-hotspots-tooltips-link" href="<?php echo esc_url($link_url); ?>"
									   title="<?php echo $item['image_hotspots_link_text']; ?>"
									   <?php if (!empty($item['image_hotspots_url']['is_external'])) : ?>target="_blank"
									   <?php endif; ?><?php if (!empty($item['image_hotspots_url']['nofollow'])) : ?>rel="nofollow"<?php endif; ?>>
										<i class="bwp-image-hotspots-icon"></i>
									</a>
								<?php else : ?>
									<i class="bwp-image-hotspots-icon"></i>
								<?php endif; ?>
								<div class="bwp-image-hotspots-tooltips-wrapper">
									<div class="tooltip_content bwp-image-hotspots-tooltips-text bwp-image-hotspots-tooltips-text-<?php echo esc_attr($this->get_id()); ?>">
										<?php
											if ($item['image_hotspots_content'] == 'image_editor') {
												$elementor_post_id = $item['image_hotspots_tooltips_temp'];
												$elements_frontend = new Frontend;
												echo $elements_frontend->get_builder_content($elementor_post_id, true);
											}else {
												echo $item['image_hotspots_tooltips_texts'];
											}
										?>
									</div>
								</div>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>