<?php     
	$image_hotspots_settings = [
		'anim'        => $settings['image_hotspots_anim'],
		'animDur'     => !empty($settings['image_hotspots_anim_dur']) ? $settings['image_hotspots_anim_dur'] : 350,
		'delay'       => !empty($settings['image_hotspots_anim_delay']) ? $settings['image_hotspots_anim_delay'] : 10,
		'arrow'       => ($settings['image_hotspots_arrow'] == 'yes') ? true : false,
		'distance'    => !empty($settings['image_hotspots_tooltips_distance_position']) ? $settings['image_hotspots_tooltips_distance_position'] : 6,
		'minWidth'    => !empty($settings['image_hotspots_min_width']['size']) ? $settings['image_hotspots_min_width']['size'] : 0,
		'maxWidth'    => !empty($settings['image_hotspots_max_width']['size']) ? $settings['image_hotspots_max_width']['size'] : 'null',
		'side'        => !empty($settings['image_hotspots_tooltips_position']) ? $settings['image_hotspots_tooltips_position'] : array(
			'right',
			'left'
		),
		'hideMobiles' => ($settings['image_hotspots_hide'] == true) ? true : false,
		'trigger'     => $settings['image_hotspots_trigger_type'],
		'id'          => $this->get_id()
	];
	?>
	<div class="bwp-hotspots <?php echo esc_attr($settings['layout']); ?>">
		<div id="bwp-image-hotspots-<?php echo esc_attr($this->get_id()); ?>"
			 class="bwp-image-hotspots-container"
			 data-settings='<?php echo wp_json_encode($image_hotspots_settings); ?>'>
			<img class="bwp-addons-image-hotspots-ib-img" alt="<?php echo esc_attr__('Background','wpbingo'); ?>" src="<?php echo esc_url($image_src_size); ?>">
			<?php foreach ($settings['image_hotspots_icons'] as $index => $item) {
				$list_item_key = 'img_hotspot_' . $index;
				$this->add_render_attribute($list_item_key, 'class',
					[
						$animation_class,
						'bwp-image-hotspots-main-icons',
						'elementor-repeater-item-' . $item['_id'],
						'tooltip-wrapper',
						'bwp-image-hotspots-main-icons-' . $item['_id']
					]);
				$this->add_render_attribute($list_item_key, 'data-tab', '#elementor-tab-title-' . $item['_id']);
				?>
				<div <?php echo $this->get_render_attribute_string($list_item_key); ?>
						data-tooltip-content="#tooltip_content">
					<?php
					$link_type = $item['image_hotspots_link_type'];
					if ($link_type == 'url') {
						$link_url = $item['image_hotspots_url']['url'];
					} elseif ($link_type == 'link') {
						$link_url = get_permalink($item['image_hotspots_existing_page']);
					}
					if ($item['image_hotspots_link_switcher'] == 'yes' && $settings['image_hotspots_trigger_type'] == 'hover') :
					?>
						<a class="bwp-image-hotspots-tooltips-link" href="<?php echo esc_url($link_url); ?>"
						   title="<?php echo $item['image_hotspots_link_text']; ?>"
						   <?php if (!empty($item['image_hotspots_url']['is_external'])) : ?>target="_blank"
						   <?php endif; ?><?php if (!empty($item['image_hotspots_url']['nofollow'])) : ?>rel="nofollow"<?php endif; ?>>
							<?php if ($item['image_hotspots_content'] == 'image_editor') { ?>
								<i class="bwp-image-hotspots-icon"><?php echo wp_get_attachment_image( $item['image_hotspots_image']['id'], 'mihouse-thumbnails-hotspots' ); ?></i>
							<?php }else{ ?>
								<i class="bwp-image-hotspots-icon"></i>
							<?php } ?>
						</a>
					<?php else : ?>
						<?php if ($item['image_hotspots_content'] == 'image_editor') { ?>
							<i class="bwp-image-hotspots-icon"><?php echo wp_get_attachment_image( $item['image_hotspots_image']['id'],'mihouse-thumbnails-hotspots' ); ?></i>
						<?php }else{ ?>
							<i class="bwp-image-hotspots-icon"></i>
						<?php } ?>
					<?php endif; ?>
					<div class="bwp-image-hotspots-tooltips-wrapper">
						<div class="tooltip_content bwp-image-hotspots-tooltips-text <?php echo esc_attr($settings['layout']); ?> bwp-image-hotspots-tooltips-text-<?php echo esc_attr($this->get_id()); ?>">
							<?php if ($item['image_hotspots_content'] == 'image_editor') { ?>
								<div class="content-hotspots"><?php echo $item['image_hotspots_tooltips_texts']; ?></div>
								<div class="image-hotspots"><?php echo wp_get_attachment_image( $item['image_hotspots_image']['id'], 'thumbnail' ); ?></div>
							<?php }else { ?>
								<?php echo $item['image_hotspots_tooltips_texts']; ?>
							<?php } ?>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>