<?php if(isset($user_id) && $user_id && isset($access_token) && $access_token ):?>
<?php $widget_id = 'instagram_' .rand().time(); ?>
<div id="<?php echo esc_attr($widget_id); ?>" class="bwp-instagram <?php echo esc_html( $layout ); ?> <?php echo esc_attr($padding); ?>" 
	data-user_id="<?php echo $user_id; ?>"
	data-rows = "<?php echo esc_attr($item_row); ?>"
	data-access_token="<?php echo $access_token; ?>"
	data-limit="<?php echo esc_attr($limit); ?>"
	data-width="<?php echo esc_attr($width); ?>"
	data-height="<?php echo esc_attr($height); ?>"
	data-text_check_user="<?php echo __( 'Please check User ID, Access token or Networking again', "wpbingo" ); ?>"
	data-text_image_show="<?php echo __( 'No Image To Show', "wpbingo" ); ?>"
	>
 <div class="block">
 	<?php if(isset($title1) && $title1) {?>
		<div class="instagram-title">
			<?php
				echo '<h2>'. esc_html($title1) .'</h2>';
			?>
		</div>
	<?php } ?>
	<div class="block_content">
		<div class="content_instagram"
			data-columns4="<?php echo esc_attr($columns4); ?>"
			data-columns3="<?php echo esc_attr($columns3); ?>"
			data-columns2="<?php echo esc_attr($columns2); ?>"
			data-columns1="<?php echo esc_attr($columns1); ?>"
			data-columns="<?php echo esc_attr($columns); ?>">
		</div>
	</div>
 </div>
</div>
<script type="text/javascript">
(function($) {
	$(document).ready(function() {
		_wpbingo_load_instagram();
		function _wpbingo_load_instagram(){
				var $element = $("#<?php echo esc_attr($widget_id); ?>");
				var value_user_id = $element.data("user_id");
				var value_access_token = $element.data("access_token");
				var value_limit = $element.data("limit");		
				if (value_user_id && value_access_token) {
					var media_users_recent = "https://api.instagram.com/v1/users/" + value_user_id + "/media/recent?access_token=" + value_access_token + "&count=" + value_limit;
					$.ajax({
						method: "GET",
						dataType: "jsonp",
						cache: false,
						url: media_users_recent,
						success: function (response) {
							var data_image = response.data;
							if (typeof (data_image) == 'undefined') {
								$(".content_instagram",$element).append("<li>"+$element.data("text_check_user")+"</li>");
								return;
							}
							
							if (data_image.length > 0) {
								var html = '';
								for (var i = 0; i < data_image.length; i++) {
									if(i < data_image.length){
										html += '<div class="image-instagram '+($(".content_instagram",$element).data("attributes") ? $(".content_instagram",$element).data("attributes") : '' )+'">'
												+ '<a class="instagram" target="_blank"  href="' + data_image[i].link + ' ">'
												+	'<img src="' + data_image[i].images.standard_resolution.url + '" alt="" title="" width="'+$element.data("width")+'" height="'+$element.data("height")+'">' 
												+ '</a>'
											+'</div>';
									}	
								}							
								$(".content_instagram",$element).html(html);
								_wpbingo_slick_carousel($(".content_instagram",$element));
							}else {
								$(".content_instagram",$element).append("<li>"+$(this).data("text_image_show")+"</li>");
								return;
							}
						},
						error: function () {
							$(".content_instagram",$element).append("<li>"+$(this).data("text_image_show")+"</li>");
						}
					})
				}	
		}

		function _wpbingo_slick_carousel($element){
			var _body    = $( 'body' );
			$element.slick({
				arrows: $element.data("nav") ? true : false ,
				dots: $element.data("dots") ? true : false ,
				prevArrow: '<i class="slick-arrow fa fa-caret-left"></i>',
				nextArrow: '<i class="slick-arrow fa fa-caret-right"></i>',	
				slidesToShow: $element.data("columns"),
				asNavFor: $element.data("asnavfor") ? $element.data("asnavfor") : false ,
				vertical: $element.data("vertical") ? true : false ,
				verticalSwiping: $element.data("verticalswiping") ? $element.data("verticalswiping") : false ,
				rtl: (_body.hasClass("rtl") && !$element.data("vertical")) ? true : false ,
				centerMode: $element.data("centermode") ? $element.data("centermode") : false ,
				focusOnSelect: $element.data("focusonselect") ? $element.data("focusonselect") : false ,
				responsive: [
					{
					  breakpoint: 1200,
					  settings: {
						slidesToShow: $element.data("columns1"),
					  }
					},				
					{
					  breakpoint: 1024,
					  settings: {
						slidesToShow: $element.data("columns2"),
					  }
					},
					{
					  breakpoint: 768,
					  settings: {
						slidesToShow: $element.data("columns3"),
						vertical: false,
						verticalSwiping : false,
					  }
					},
					{
					  breakpoint: 480,
					  vertical: false,
					  verticalSwiping : false,				  
					  settings: {
						slidesToShow: $element.data("columns4"),
						vertical: false,
						verticalSwiping : false,					
					  }
					}
				]								
			});	
		}
	});
})(jQuery);	
</script>
<?php endif;?>