<?php
namespace ElementorWpbingo\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Bwp_Image extends Widget_Base {
	public function get_name() {
		return 'bwp_image';
	}
	public function get_title() {
		return __( 'Wpbingo Image', 'wpbingo' );
	}
	public function get_icon() {
		return 'fa fa-picture-o';
	}	
	public function get_categories() {
		return [ 'general' ];
	}
	protected function _register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'wpbingo' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);		
		$this->add_control(
			'title1',
			[
				'label' => __( 'Title', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => __( 'Type your title here', 'wpbingo' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label' => __( 'Sub Title', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => __( 'Type your sub title here', 'wpbingo' ),
			]
		);
		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '#',
				'placeholder' => __( 'Type your title here', 'wpbingo' ),
			]
		);		
		$this->add_control(
			'button',
			[
				'label' => __( 'Button', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => __( 'Type your button here', 'wpbingo' ),
			]
		);		
		$this->add_control(
			'desc',
			[
				'label' => __( 'Description', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => '',
				'placeholder' => __( 'Type your description here', 'wpbingo' ),
			]
		);		
		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'layout',
			[
				'label' => __( 'Layout', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default'  => __( 'Default', 'wpbingo' ),
					'style-2' => __( 'Style 2', 'wpbingo' ),
					'style-3' => __( 'Style 3', 'wpbingo' ),
					'style-4' => __( 'Style 4', 'wpbingo' ),
					'nostyle' => __( 'No Style', 'wpbingo' ),
				],
			]
		);		
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		$title1 = ( $settings['title1'] ) ? $settings['title1'] : '';
		$link		 = 	( $settings['link'] ) ? $settings['link'] : '';
		$subtitle		 = 	( $settings['subtitle'] ) ? $settings['subtitle'] : '';
		$description		 = 	( $settings['desc'] ) ? $settings['desc'] : '';
		$button		 = 	( $settings['button'] ) ? $settings['button'] : '';
		$image		 = 	( $settings['image'] && $settings['image']['url'] ) ? $settings['image']['url'] : '';
		$layout		 = 	( $settings['layout'] ) ? $settings['layout'] : 'default';
		echo $args['before_widget'];
		if( $settings['layout'] == 'nostyle' ){
			include(WPBINGO_WIDGET_TEMPLATE_PATH.'bwp-image/nostyle.php' );
		}elseif( $settings['layout'] == 'default' ){
			include(WPBINGO_WIDGET_TEMPLATE_PATH.'bwp-image/default.php' );
		}elseif( $settings['layout'] == 'style-2' || $settings['layout'] == 'style-3' ){
			include(WPBINGO_WIDGET_TEMPLATE_PATH.'bwp-image/style-2.php' );
		}elseif( $settings['layout'] == 'style-4' ){
			include(WPBINGO_WIDGET_TEMPLATE_PATH.'bwp-image/style-4.php' );
		}
	}
}
