<?php
/*
Plugin Name: Wpbingo Core
Plugin URI: https://themeforest.net/user/wpbingo
Description: Use For Wpbingo Theme.
Version: 1.0
Author: TungHV
Author URI: https://themeforest.net/user/wpbingo
*/

// don't load directly
if (!defined('ABSPATH'))
    die('-1');

require_once( dirname(__FILE__) . '/function.php');
require_once( dirname(__FILE__) . '/elementor.php');
define('WPBINGO_WIDGET_PATH', dirname(__FILE__) . '/widgets/');
define('WPBINGO_WIDGET_TEMPLATE_PATH', dirname(__FILE__) . '/widgets-template/');
define('WPBINGO_CONTENT_TYPES_LIB', dirname(__FILE__) . '/lib/');
class WpbingoShortcodesClass {
    function __construct() {
        // Init plugins
		$this->loadInit();
		add_filter( 'wp_calculate_image_srcset', array( $this, 'bwp_disable_srcset' ) );
		load_plugin_textdomain('wpbingo', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }
	function loadInit() {
		global $woocommerce;
		add_action('wp_enqueue_scripts', array( $this, 'bwp_framework_script' ) );	
		require_once(WPBINGO_CONTENT_TYPES_LIB.'settings/save_settings.php');	
		$this->bwp_load_file(WPBINGO_CONTENT_TYPES_LIB);	
    }
	function bwp_load_file($path){
		$files = array_diff(scandir($path), array('..', '.'));
		if(count($files)>0){
			foreach ($files as  $file) {
				if (strpos($file, '.php') !== false)
					require_once($path . $file);
			}
		}		
	}
	function bwp_framework_script(){
		wp_enqueue_script('bwp-wpbingo-js',plugins_url( '/wpbingo/assets/js/wpbingo.js' ),array("jquery"),false,true);
		wp_enqueue_script('tooltipster-bundle',plugins_url( '/wpbingo/assets/js/tooltipster.bundle.min.js' ),array("jquery"),false,true);
		wp_enqueue_script('scrollbar',plugins_url( '/wpbingo/assets/js/jquery.scrollbar.min.js' ),array("jquery"),false,true);
		wp_enqueue_script('bwp-hostspots-js',plugins_url( '/wpbingo/assets/js/hostspots.js' ),array("jquery"),false,true);
		wp_enqueue_style('tooltipster-bundle', plugins_url( '/wpbingo/assets/css/tooltipster.bundle.min.css'), array(), null);
		wp_enqueue_style('scrollbar', plugins_url( '/wpbingo/assets/css/jquery.scrollbar.css'), array(), null);
	}
	function bwp_disable_srcset( $sources ) {		
		return false;	
	}
}

// Finally initialize code
new WpbingoShortcodesClass();

	
	