(function($) {
	"use strict";
	//Load more Blog
	$( ".recent-post-loadmore" ).each(function() {
		var $element = $(this);
		 $("button",$element).click(function(e) {
			e.preventDefault(); 
			var paged = $(".count_loadmore", $element).val();
			$.ajax({
				type: "POST", 
				url: $element.data("url"),
				dataType: 'json',
				data: {
					action 		: "bwp_blog_load_more_callback",
					numberposts :  $element.data("numberposts"),
					classes 	:  $element.data("classes"),
					total 		:  $element.data("total"),
					length 		:  $element.data("length"),
					attributes 	:  $element.data("attributes"),
					paged 		: 	paged,
				},
				beforeSend: function() {
	                $('button',$element).addClass('loading');
	            },				
				success: function (result) {	
					if (result.blogs){
						$('.content_loadmore',$element).append(result.blogs);
						paged = parseInt(paged) + 1;
						$('.count_loadmore',$element).val(paged);
						_wpbingo_click_quickview_button();
					}
					if(result.check_loadmore == 1)
						$('.blog_loadmore',$element).hide();
					 	$('button',$element).removeClass('loading');
				}
			});
		});	
	});
	
	//Filter Blog
	$( ".bwp-filter-post" ).each(function() {
		var $element = $(this);
		var $list = $(".category-list",$element);
		 $("li",$list).click(function() {
			if($(this).hasClass("active")){
				$(this).removeClass("active");
			}else{
				$(this).addClass("active");
			}
			var category = $element.data("category");
			var categories  = [];
			$("li.active",$list).each(function(index){
				categories[index] = $(this).data("catid");
			});
			if(category){
				categories[$("li.active",$list).length] = category;
			}
			$.ajax({
				type: "POST", 
				url: $element.data("url"),
				dataType: 'json',
				data: {
					action 		: "bwp_blog_filter_callback",
					numberposts :  $element.data("numberposts"),
					classes 	:  $element.data("classes"),
					length 		:  $element.data("length"),
					attributes 	:  $element.data("attributes"),
					categories 	:  categories,
				},
				beforeSend: function() {
					$('.block_content',$element).addClass('active');
					$('.block_content',$element).append('<div class="loading"><div class="chasing-dots"><div></div><div></div><div></div></div></div>');
	            },			
				success: function (result) {
					$('.block_content',$element).replaceWith(result.blogs);
					$('.category-main',$element).html(result.name_category);
					$('.block_content',$element).removeClass('active');
				}
			});
		});	
	});
	
	//Filter Tags Blog
	$( ".bwp-filter-tag-post" ).each(function() {
		var $element = $(this);
		var $list = $(".block_heading",$element);
		 $("li",$list).click(function() {
			if($(this).parent().hasClass("tag-list")){
				if($(this).hasClass("active"))
					$(this).removeClass("active");
				else
					$(this).addClass("active");
			}
			if($(this).parent().hasClass("sort-columns")){
				$("li",$(this).parent()).removeClass("active");
				$(this).addClass("active");
			}
			var tagids  = [];
			var $tagids = $(".tag-list",$list);
			var $columns = $(".sort-columns",$list);
			var $tags_null = 0;
			if($("li.active",$tagids).length){
				$("li.active",$tagids).each(function(index){
					tagids[index] = $(this).data("tagid");
				});
			}else{
				$tags_null = 1;
				$("li",$tagids).each(function(index){
					tagids[index] = $(this).data("tagid");
				});
			}
			$.ajax({
				type: "POST", 
				url: $element.data("url"),
				dataType: 'json',
				data: {
					action 		: "bwp_blog_filter_tag_callback",
					numberposts :  $element.data("numberposts"),
					classes 	:  $element.data("classes"),
					length 		:  $element.data("length"),
					attributes 	:  $("li.active",$columns).data("attributes"),
					tagids 		:  tagids,
					tags_null	:  $tags_null
				},
				beforeSend: function() {
					$('.block_content',$element).addClass('active');
					$('.block_content',$element).append('<div class="loading"><div class="chasing-dots"><div></div><div></div><div></div></div></div>');
	            },			
				success: function (result) {
					$('.block_content',$element).replaceWith(result.blogs);
					$('.block_content',$element).removeClass('active');
				}
			});
		});	
	});	
	
	function _click_drop_categories(){
		$('.title-categories-list').on( "click", function() {
			if($('.category-list').hasClass('active'))
				$('.category-list').removeClass('active');
			else
				$('.category-list').addClass('active');
			return false;
		});		
	}
	
	_click_drop_categories();
	
	function _click_drop_col_tag(){
		$('.bwp-col-columns').on( "click", function() {
			if($('.sort-columns').hasClass('active'))
				$('.sort-columns').removeClass('active');
			else
				$('.sort-columns').addClass('active');
			return false;
		});		
	}
	
	_click_drop_col_tag();
	
})(jQuery);
