<?php
	function bwp_timezone_offset( $countdowntime ){
		$timeOffset = 0;	
		if( get_option( 'timezone_string' ) != '' ) :
			$timezone = get_option( 'timezone_string' );
			$dateTimeZone = new DateTimeZone( $timezone );
			$dateTime = new DateTime( "now", $dateTimeZone );
			$timeOffset = $dateTimeZone->getOffset( $dateTime );
		else :
			$dateTime = get_option( 'gmt_offset' );
			$dateTime = intval( $dateTime );
			$timeOffset = $dateTime * 3600;
		endif;
		$offset =  ( $timeOffset < 0 ) ? '-' . gmdate( "H:i", abs( $timeOffset ) ) : '+' . gmdate( "H:i", $timeOffset );
		
		$date = date( 'Y/m/d H:i:s', $countdowntime );
		$date1 = new DateTime( $date );
		$cd_date =  $date1->format('Y-m-d H:i:s') . $offset;
		
		return strtotime( $cd_date ); 
	}		

	if ( ! function_exists( 'wpbingo_posted_on' ) ) :

	function wpbingo_posted_on() {
		if ( is_sticky() && is_home() && ! is_paged() ) {
			echo '<span class="featured-post">' . esc_html__( 'Sticky', 'wpbingo' ) . '</span>';
		}

		// Set up and print post meta information.
		printf( '<span class="entry-date"><time class="entry-date" datetime="%2$s">%3$s</time></span>',
			esc_url( get_permalink() ),
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date('M d, Y') )
		);		
	}
	endif;

	if ( ! function_exists( 'wpbingo_posted_on2' ) ) :

	function wpbingo_posted_on2() {
		if ( is_sticky() && is_home() && ! is_paged() ) {
			echo '<span class="featured-post">' . esc_html__( 'Sticky', 'wpbingo' ) . '</span>';
		}

		// Set up and print post meta information.
		printf( '<span class="entry-date"><time class="entry-date" datetime="%2$s">%3$s, %4$s, %5$s, %6$s</time></span>',
			esc_url( get_permalink() ),
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date('l')),
			esc_html( get_the_date('F j')),
			esc_html( get_the_date('Y')),
			esc_html( get_the_date('g:i a') )
		);			

	}
	endif;

	if ( ! function_exists( 'wpbingo_posted_on3' ) ) :

	function wpbingo_posted_on3() {
		if ( is_sticky() && is_home() && ! is_paged() ) {
			echo '<span class="featured-post">' . esc_html__( 'Sticky', 'wpbingo' ) . '</span>';
		}

		printf( '<span class="entry-date"><time class="entry-date" datetime="%2$s"><span class="date">%3$s %4$s %5$s</span></time></span>',
			esc_url( get_permalink() ),
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date('d')),
			esc_html( get_the_date('M')),
			esc_html( get_the_date('Y')),
			esc_html( get_the_date('g:i a') )
		);			

	}
	endif;
	
	if ( ! function_exists( 'wpbingo_posted_on4' ) ) :

	function wpbingo_posted_on4() {
		if ( is_sticky() && is_home() && ! is_paged() ) {
			echo '<span class="featured-post">' . esc_html__( 'Sticky', 'wpbingo' ) . '</span>';
		}

		// Set up and print post meta information.
		printf( '<span class="entry-date"><time class="entry-date" datetime="%2$s"><span class="date">%3$s</span> %4$s</time></span>',
			esc_url( get_permalink() ),
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date('d')),
			esc_html( get_the_date('M')),
			esc_html( get_the_date('Y')),
			esc_html( get_the_date('g:i a') )
		);			

	}
	endif;

	if ( ! function_exists( 'wpbingo_get_excerpt' ) ) :
	function wpbingo_get_excerpt($limit = 45, $more_link = true, $more_style_block = false) {
		if (!$limit) {
			$limit = 45;
		}

		if (has_excerpt()) {
			$content = get_the_excerpt();
		} else {
			$content = get_the_content();
		}

		$content = wpbingo_strip_tags( apply_filters( 'the_content', $content ) );
		$content = explode(' ', $content, $limit);

		if (count($content) >= $limit) {
			array_pop($content);
			$content = implode(" ",$content).'... ';
		} else {
			$content = implode(" ",$content);
		}
		
		$content = '<p class="post-excerpt">'.$content.'</p>';

		if ($more_link) {
			$content .= '<div class="btn-read-more"><a class="read-more" href="'.esc_url( apply_filters( 'the_permalink', get_permalink() ) ).'">'.esc_html__('Read more', 'wpbingo').'</a></div>';
		}		
	
		return $content;
	}
	endif;

	if ( ! function_exists( 'wpbingo_strip_tags' ) ) :
	function wpbingo_strip_tags( $content ) {
		$content = str_replace( ']]>', ']]&gt;', $content );
		$content = preg_replace("/<script.*?\/script>/s", "", $content) ? : $content;
		$content = preg_replace("/<style.*?\/style>/s", "", $content) ? : $content;
		$content = strip_tags( $content );
		return $content;
	}	
	endif;

	if(!function_exists('get_header_types')) :
		function get_header_types() {
			$header = array('' => esc_html__( 'Default', 'wpbingo' ));
			$path = get_template_directory().'/templates/headers/';
			$files = array_diff(scandir($path), array('..', '.'));
			if(count($files)>0){
				foreach ($files as  $file) {
					$name = str_replace( '.php', '', basename($file) );
					$value = str_replace( 'header-', '',$name);
					$name =  str_replace( '-', ' ', ucwords($name) );
					$header[$value] = $name;
				}
			}		
			return $header;
		}
	endif;

	if(!function_exists('get_footers_types')) :
		function get_footers_types() {
			$footer = array('' => esc_html__( 'Default', 'wpbingo' ));
			$footers = get_posts( array('posts_per_page'=>-1,
										'post_type'=>'bwp_footer',
										'orderby'          => 'name',
										'order'            => 'ASC'
								) );
			foreach ($footers as  $value) {
				$footer[$value->ID] = $value->post_title;
			}
			return $footer;
		}
	endif;
	
	if(!function_exists('wpbingo_remove_object_filter')) :
		function wpbingo_remove_object_filter($tag, $class, $method) {
			$filters = (isset($GLOBALS['wp_filter'][$tag]) && $GLOBALS['wp_filter'][$tag]) ? $GLOBALS['wp_filter'][$tag] : "";
			if (empty($filters)){
				return;
			}
			if(version_compare(get_bloginfo('version'), '4.7', '>=')) {
				$callbacks = $filters->callbacks;
			} else {
				$callbacks = $filters;
			}
			foreach ($callbacks as $priority => $filter) {
				foreach ($filter as $identifier => $function) {
					if (is_array( $function) && is_a( $function['function'][0], $class ) && $method === $function['function'][1]) {
					  remove_filter($tag, array ( $function['function'][0], $method ), $priority);
					}
				}
			}
		}
	endif;
	
	if(!function_exists('wpbingo_category_post')) :
	function wpbingo_category_post(){
		global $post;
		$obj_category = new stdClass;
		$term_list = wp_get_post_terms($post->ID,'category',array('fields'=>'ids'));
		if($term_list){
			$cat_id = (int)$term_list[0];
			$category = get_term( $cat_id, 'category' );
			$obj_category->name = $category->name;
			$obj_category->cat_link = get_term_link ($cat_id, 'category');	
			return $obj_category;
		}
	}
	endif;
	