<?php
	$class_col_lg = ($columns == 5) ? '2-4'  : (12/$columns);
	$class_col_md = ($columns1 == 5) ? '2-4'  : (12/$columns1);
	$class_col_sm = ($columns2 == 5) ? '2-4'  : (12/$columns2);
	$class_col_xs = ($columns3 == 5) ? '2-4'  : (12/$columns3);
	$attributes = 'col-lg-'.$class_col_lg .' col-md-'.$class_col_md .' col-sm-'.$class_col_sm .' col-xs-'.$class_col_xs;	
	$tag_id = 'apartment_post_' .rand().time();
	$args = array(
		'post_type' => 'apartment',
		'posts_per_page' => $numberposts,
		'post_status' => 'publish'
	);
	$query = new WP_Query($args);
?>
<?php if($query->have_posts()):?>
<div id="<?php echo esc_html($tag_id); ?>" class="bwp-apartment <?php echo esc_attr($layout); ?>">
	<?php if (isset($title1) && $title1){ ?>
	<div class="title-block">
	<?php echo '<h2>'. esc_html($title1) .'</h2>'; ?>
	</div>
	<?php } ?>
	<div class="block_content">
		<?php while($query->have_posts()):$query->the_post(); ?>
		<div class="apartment-item <?php echo esc_html($attributes); ?>">
			<div class="apartment-image">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('full', array( 'class' => 'img-responsive' )) ?></a>
			</div>
			<div class="post-content">
				<h3 class="entry-title"><a href="<?php echo esc_url(the_permalink()) ?>"><?php echo the_title(); ?></a></h3>
				<a class="button" href="<?php echo esc_url(the_permalink()) ?>"><?php echo esc_html__("Explore","mihouse") ?></a>
			</div>
		</div>
		<?php endwhile; ?>
	</div>
</div>
<?php endif;?>