<?php $tag_id = 'apartment_post_' .rand().time(); 
	$args = array(
		'post_type' => 'apartment',
		'posts_per_page' => $numberposts,
		'post_status' => 'publish'
	);
 
	$query = new WP_Query($args);
?>
<?php if($query->have_posts()):?>
<div id="<?php echo esc_html($tag_id); ?>" class="bwp-apartment <?php echo esc_attr($layout); ?>">
	<div class="block">
		<?php if (isset($title1) && $title1){ ?>
		<div class="title-block">
			<?php echo '<h2>'. $title1 .'</h2>'; ?>
		</div>
		<?php } ?>
		<div class="block_content">
			<div class="slider slick-carousel" data-nav="<?php echo esc_attr($show_nav);?>" data-columns4="<?php echo esc_attr($columns4); ?>" data-columns3="<?php echo esc_attr($columns3); ?>" data-columns2="<?php echo esc_attr($columns2); ?>" data-columns1="<?php echo esc_attr($columns1); ?>" data-columns="<?php echo esc_attr($columns); ?>">	
			<?php while($query->have_posts()):$query->the_post(); ?>
				<!-- Wrapper for slides -->
				<div class="apartment-item">
					<h2 class="entry-title"><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h2>
					<div class="apartment-image">
						<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('full', array( 'class' => 'img-responsive' )) ?></a>
					</div>
				</div>
				<?php endwhile; wp_reset_postdata();?>
			</div>
		</div>
	</div>
</div>
<?php endif;?>