<?php
	$class_col_lg = ($columns == 5) ? '2-4'  : (12/$columns);
	$class_col_md = ($columns1 == 5) ? '2-4'  : (12/$columns1);
	$class_col_sm = ($columns2 == 5) ? '2-4'  : (12/$columns2);
	$class_col_xs = ($columns3 == 5) ? '2-4'  : (12/$columns3);
	$attributes = 'col-lg-'.$class_col_lg .' col-md-'.$class_col_md .' col-sm-'.$class_col_sm .' col-xs-'.$class_col_xs;
	$classes = array('post-grid',$attributes);	
	$tag_id = 'recent_post_' .rand().time(); 
	$args = array(
		'post_type' => 'post',
		'cat' => $category, 
		'posts_per_page' => $limit
	);
	//Blog First
	$query = new WP_Query($args);
	$post_count = $query->post_count;
	//Total
	$args_count 	= 	$args;
	$args_count['showposts'] 	= 	-1;
	$wp_query_count = new WP_Query($args_count);	
	$total = $wp_query_count->post_count;
?>
<?php if($query->have_posts()):?>
<div class="bwp-recent-post recent-post-loadmore loadmore"
		data-numberposts = "<?php echo esc_attr($limit); ?>"
		data-total	= 	"<?php echo esc_attr($total); ?>"
		data-attributes	= 	"<?php echo esc_attr( $attributes ); ?>"
		data-category = "<?php echo esc_attr($category); ?>"
		data-length = "<?php echo esc_attr($length); ?>"
		data-url = "<?php echo esc_url(admin_url( 'admin-ajax.php' )); ?>">
 	<?php if(isset($title1) && $title1) { ?>
	<div class="title-block">
		<h2><?php echo esc_html($title1); ?></h2>
		<?php if($description) { ?>
		<div class="page-description"><?php echo esc_html($description); ?></div>
		<?php } ?>
	</div>
	<?php } ?>
    <div class="block_content">
	    <div id="<?php echo esc_attr($tag_id); ?>" class="content_loadmore row">
			<?php while($query->have_posts()):$query->the_post(); ?>
			<!-- Wrapper for slides -->
				<div  <?php post_class( $classes ); ?>>
					<?php wpbingo_posted_on3(); ?>	
					<div class="post-inner style">
						<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
						<?php
							if( has_post_thumbnail() ) :
								the_post_thumbnail( 'mihouse-full-width', array( 'alt' => get_the_title() ) );
							else :
								echo '<img src="' . esc_url( get_template_directory_uri() . '/images/placeholder.jpg' ) . '" alt="' . get_the_title() . '">';
							endif;
						?>
						</a>
						<div class="post-content">
							<h2 class="entry-title"><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h2> 	 
							<?php echo wpbingo_get_excerpt( $length, true ); ?>	
							<a class="post-btn-more" href="<?php echo esc_url(the_permalink()) ?>"> <?php echo  esc_html_e( 'Read more', 'wpbingo' ) ?></a>	
						</div>
					</div>
				</div><!-- #post-## -->	
			<?php endwhile; wp_reset_postdata(); ?>
	    </div>
    </div>
	<?php if($total > $limit) : ?>
    <div class="blog_loadmore">
		<button type="button" class="btn btn-default loadmore" name="loadmore">
			<i class="fa fa-refresh" aria-hidden="true"></i>
			<span><?php echo esc_html__('Load More', 'wpbingo'); ?></span>
		</button>
		<input type="hidden"  value="2" class="count_loadmore" />
	</div>
	<?php endif; ?>
</div>
<?php endif;?>