<?php
namespace ElementorWpbingo\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class Bwp_Coutdown extends Widget_Base {
	public function get_name() {
		return 'bwp_coutdown';
	}
	public function get_title() {
		return __( 'Wpbingo Coutdown', 'wpbingo' );
	}
	public function get_icon() {
		return 'fa fa-sort-numeric-desc';
	}	
	public function get_categories() {
		return [ 'general' ];
	}
	protected function _register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'wpbingo' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);		
		$this->add_control(
			'title1',
			[
				'label' => __( 'Title', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => __( 'Type your title here', 'wpbingo' ),
			]
		);
		$this->add_control(
			'desc',
			[
				'label' => __( 'Description', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'rows' => 10,
				'default' => '',
				'placeholder' => __( 'Type your description here', 'wpbingo' ),
			]
		);
		$this->add_control(
			'timedeal',
			[
				'label' => __( 'Time Deal', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => __( 'Type your time end here', 'wpbingo' ),
				'description' => __( 'Ex : 2019-5-25', 'wpbingo' ),
			]
		);
		$this->add_control(
			'layout',
			[
				'label' => __( 'Layout', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default'  => __( 'Default', 'wpbingo' )
				],
			]
		);		
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		$title1 = ( $settings['title1'] ) ? $settings['title1'] : '';
		$desc		 = 	( $settings['desc'] ) ? $settings['desc'] : '';	
		$timedeal = ( $settings['timedeal'] ) ? $settings['timedeal'] : '';
		$layout		 = 	( $settings['layout'] ) ? $settings['layout'] : 'default';
		if( $settings['layout'] == 'default' ){
			include(WPBINGO_WIDGET_TEMPLATE_PATH.'bwp-coutdown/default.php' );
		}
	}
}
