<?php 
	get_header(); 
	$mihouse_settings = mihouse_global_settings();
	$background 	= 	mihouse_get_config('background');
	$bgs 			= 	( isset($mihouse_settings['img-404']['url']) ) ? $mihouse_settings['img-404']['url'] : get_template_directory_uri() . '/images/image_404.png';
	$title_error 	=	( isset($mihouse_settings['title-error']) && $mihouse_settings['title-error'] ) ? $mihouse_settings['title-error'] : esc_html__('404', 'mihouse');
	$title_error_1 	= 	( isset($mihouse_settings['title-error-1']) && $mihouse_settings['title-error-1'] ) ? $mihouse_settings['title-error-1'] : esc_html__('Oops...', 'mihouse');
	$title_error_2 	= 	( isset($mihouse_settings['title-error-2']) && $mihouse_settings['title-error-2'] ) ? $mihouse_settings['title-error-2'] : esc_html__('Page not found', 'mihouse');
	$text_error_1	= 	( isset($mihouse_settings['text-error1']) && $mihouse_settings['text-error1'] ) ? $mihouse_settings['text-error1'] : esc_html__('Oops! The page you are looking for does not exist.', 'mihouse');
	$text_error_2	= 	( isset($mihouse_settings['text-error2']) && $mihouse_settings['text-error2'] ) ? $mihouse_settings['text-error2'] : esc_html__('It might have been moved or deleted.', 'mihouse');
	$btn_error 		=	( isset($mihouse_settings['btn-error']) && $mihouse_settings['btn-error'] ) ? $mihouse_settings['btn-error'] : esc_html__('Back to home', 'mihouse');
	$class_empty 	= 	(empty($bgs)) ? " empty-image" : "";
?>
<div class="content-404" <?php echo (!empty($bgs) ? ' style="background-image:url(' . esc_url( $bgs ) . ');"' : ''); ?>>
	<div class="container">
		<div class="row">
			<div class="col-sm-6 hidden-xs"></div>
			<div class="col-sm-6 col-xs-12">
				<div class="contact-info-404">
					<?php if( $title_error || $title_error_1 || $title_error_2 ){ ?>
					<div class="title-error">
						<?php if($title_error){ ?>
							<div class="title-error-top">
								<?php echo esc_html($title_error); ?>
							</div>
						<?php } ?>
						<span class="sub-title-error">
							<span><?php echo esc_html($title_error_1); ?></span>
							<?php echo esc_html($title_error_2); ?>
						</span>
					</div>
					<?php } ?>
					<?php if( $text_error_1 || $text_error_2 || $btn_error ){ ?>
					<div class="content-page-404">
						<div class="text-error"><?php echo esc_html($text_error_1); ?></div>
						<div class="text-error-2"><?php echo esc_html($text_error_2); ?></div>
						<a class="btn" href="<?php echo esc_url( home_url('/') ); ?>"><?php echo esc_html($btn_error); ?></a>
					</div>
					<?php } ?>
				</div>
			</div>
		</div> 
	</div>
</div>
<?php
get_footer();