<?php $mihouse_settings = mihouse_global_settings(); ?>
<article id="post-<?php esc_attr(the_ID()); ?>" <?php post_class(); ?>>
	<?php if ( get_the_post_thumbnail() ){ ?>
		<div class="entry-thumb single-thumb">
			<?php the_post_thumbnail( 'full' ); ?>
		</div>
	<?php }; ?>
	<?php if ( is_search() ) : ?>
	<div class="entry-summary">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->
	<?php else : ?>
	<div class="post-content">
		<?php
			$show_post_title = mihouse_get_config('post-title',true);
			if ($show_post_title){
				if ( is_single() ){
					the_title( '<h3 class="entry-title">', '</h3>' );
				}else {
					the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
				}
			}
		?>
		<div class="entry-meta hidden">
			<div class="cat-links"><?php echo get_the_category_list( esc_html_e( 'Used between list items, there is a space after the comma.', 'mihouse' ) ); ?></div>
		</div>
		<div class="post-excerpt"><?php
				/* translators: %s: Name of current post */
				the_content( sprintf(
					the_title( '<span class="screen-reader-text">', '</span>', false )
				) );
				wp_link_pages( array(
					'link_before' => '<span>',
					'link_after'  => '</span>',
				) );
			?>
		</div>
		<div class="clearfix"></div>
	</div><!-- .entry-content -->
	<?php endif; ?>
</article><!-- #post-## -->