<?php $mihouse_settings = mihouse_global_settings(); ?>
<article id="post-<?php esc_attr(the_ID()); ?>" <?php post_class(); ?>>
<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && mihouse_categorized_blog() ) : ?>
	<?php
	endif;
		$show_post_title = mihouse_get_config('post-title',true);
		if ($show_post_title){
			if ( is_single() ){
				the_title( '<h3 class="entry-title">', '</h3>' );
			}else {
				the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
			}
		}
	?>
	<div class="entry-info">
		<div class="entry-time-post">
			<span class="text-reader"><?php echo esc_html__('On','mihouse');?></span>
			<?php echo mihouse_time_link1();?>
		</div>
		<?php $categories_list = get_the_category_list( wp_kses_post( '<span> , </span>', 'mihouse' ) );
		if ( $categories_list ) : ?>
			<span class="cat-links">
				<div class="post-categories">
					<span class="text-reader"><?php echo esc_html__('In ','mihouse');?></span>
					<?php					
					echo wp_kses_post( $categories_list );
					?>
				</div>
			</span>
		<?php endif; // End if categories. ?>
		<span class="entry-meta-link"><span class="text-reader"><?php echo esc_html__('Posted By ','mihouse'); ?></span><?php the_author_posts_link(); ?></span>
		<?php if ( shortcode_exists( 'social_share' ) ) : ?> 
			<div class="entry-social-share">
				<span class="text-reader"><?php echo esc_html__('Share:','mihouse');?></span>
				<?php echo do_shortcode( "[social_share]" ); ?>	
			</div>
		<?php endif; ?>
	</div>
	<?php if ( get_the_post_thumbnail() ){ ?>
		<div class="entry-thumb single-thumb">
			<?php the_post_thumbnail( 'full' ); ?>
		</div>
	<?php }; ?>
	<?php if ( is_search() ) : ?>
	<div class="entry-summary">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->
	<?php else : ?>
	<div class="post-content">
		<div class="entry-meta hidden">
			<div class="cat-links"><?php echo get_the_category_list( esc_html_e( 'Used between list items, there is a space after the comma.', 'mihouse' ) ); ?></div>
		</div>
		<div class="post-excerpt"><?php
				/* translators: %s: Name of current post */
				the_content( sprintf(
					the_title( '<span class="screen-reader-text">', '</span>', false )
				) );
				wp_link_pages( array(
					'link_before' => '<span>',
					'link_after'  => '</span>',
				) );
			?>
		</div>
		<div class="post-entry-bottom">
			<!-- Tag -->
			<?php if(get_the_tag_list()) { ?>
			<div class="entry-tag single-tag">
				<?php echo get_the_tag_list('<span class="custom-font title-tag">'.esc_html__('Tags','mihouse').': </span>');  ?>
			</div>
			<?php } ?>
			<!-- Previous/next post navigation. -->
			<?php mihouse_post_nav(); ?>
		</div>
		<div class="clearfix"></div>
	</div><!-- .entry-content -->
	<?php endif; ?>
</article><!-- #post-## -->