<?php
/**
 * Version:            1.0.0
 * Theme Name:         mihouse
 * Theme URI:          http://wpbingosite.com/themes/mihouse/
 * Author:             Wpbingo
 * Author URI:         http://wpbingosite.com/
 * License:            GNU General Public License v2 or later
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<?php 
	global $page_id;
	$mihouse_settings = mihouse_global_settings();
	$direction = mihouse_get_direction(); 
	$page_id = get_the_ID();	
	$header_style = mihouse_get_config('header_style', ''); 
	$header_style  = (get_post_meta( $page_id, 'page_header_style', true )) ? get_post_meta($page_id, 'page_header_style', true ) : $header_style ;
	$enable_sticky_header = ( isset($mihouse_settings['enable-sticky-header']) && $mihouse_settings['enable-sticky-header'] ) ? ($mihouse_settings['enable-sticky-header']) : false;
	$show_searchform = (isset($mihouse_settings['show-searchform']) && $mihouse_settings['show-searchform']) ? ($mihouse_settings['show-searchform']) : false;	
?>
<!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php esc_url(bloginfo( 'pingback_url' )); ?>">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<?php mihouse_loading_overlay(); ?>
<div id='page' class="hfeed page-wrapper">
	<?php if(isset($header_style) && $header_style) { ?>
		<?php get_template_part('templates/headers/header',$header_style); ?>
	<?php }else{ ?>
		<div id='bwp-header' class="bwp-header bwp-header-default">
			<div class="container">
				<div class='header-content' data-sticky_header="<?php echo esc_attr($enable_sticky_header); ?>">
					<div class="row">
						<?php if($show_searchform ){ ?>
						<div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 header-logo">
							<?php mihouse_header_logo(); ?>
						</div>
						<div class="col-lg-8 col-md-8 col-sm-6 col-xs-6 wpbingo-menu-mobile">
							<?php mihouse_top_menu(); ?>
						</div>
						<div class="col-lg-2 col-md-2 col-sm-6 col-xs-6 margin-top-20 header-right">
							<div class="search-box pull-right">
								<div class="search-toggle"><i class="fa fa-search"></i></div>
								<div class="dropdown-search"><?php get_search_form(); ?></div>
							</div>
						</div>
						<?php }else{ ?>
						<div class="col-lg-2 col-md-2 col-sm-6 col-xs-6 header-logo">
							<?php mihouse_header_logo(); ?>
						</div>
						<div class="col-lg-10 col-md-10 col-sm-6 col-xs-6 wpbingo-menu-mobile">
							<?php mihouse_top_menu(); ?>
						</div>		
						<?php } ?>
					</div>
				</div>
			</div>
		</div><!-- End header-wrapper -->	
	<?php } ?>
<div id="bwp-main" class="bwp-main">
<?php mihouse_page_title(); ?>