<?php
	function mihouse_get_config($option,$default='1'){
		$mihouse_settings = mihouse_global_settings();
		$query_string = mihouse_get_query_string();
		parse_str($query_string, $params);
		if(isset($params[$option]) && $params[$option]){
			return $params[$option];
		}
		else{
			$value = isset($mihouse_settings[$option]) ? $mihouse_settings[$option] : $default;
			return $value;
		}
	}
	function mihouse_get_query_string(){
		global $wp_rewrite;
		$request = remove_query_arg( 'paged' );
		$home_root = parse_url(home_url());
		$home_root = ( isset($home_root['path']) ) ? $home_root['path'] : '';
		$home_root = preg_quote( $home_root, '|' );
		$request = preg_replace('|^'. $home_root . '|i', '', $request);
		$request = preg_replace('|^/+|', '', $request);
		$request = preg_replace( "|$wp_rewrite->pagination_base/\d+/?$|", '', $request);
		$request = preg_replace( '|^' . preg_quote( $wp_rewrite->index, '|' ) . '|i', '', $request);
		$request = ltrim($request, '/');
		$qs_regex = '|\?.*?$|';
		preg_match( $qs_regex, $request, $qs_match );
		if ( !empty( $qs_match[0] ) ) {
			$query_string = $qs_match[0];
			$query_string = str_replace("?","",$query_string);
		} else {
			$query_string = '';
		}
		return 	$query_string;
	}
	function mihouse_addURLParameter($url, $paramName, $paramValue) {
		 $url_data = parse_url($url);
		 if(!isset($url_data["query"]))
			 $url_data["query"]="";
		 $params = array();
		 parse_str($url_data['query'], $params);
		 $params[$paramName] = $paramValue;
		 $url_data['query'] = http_build_query($params);
		 return mihouse_build_url( $url_data );
	}	
	function mihouse_build_url($url_data) {
		$url="";
		if(isset($url_data['host'])){
			 $url .= $url_data['scheme'] . '://';
			 if (isset($url_data['user'])) {
				 $url .= $url_data['user'];
					 if (isset($url_data['pass'])) {
						 $url .= ':' . $url_data['pass'];
					 }
				 $url .= '@';
			 }
			 $url .= $url_data['host'];
			 if (isset($url_data['port'])) {
				 $url .= ':' . $url_data['port'];
			 }
		}
		if (isset($url_data['path'])) {
			$url .= $url_data['path'];
		}
		if (isset($url_data['query'])) {
			$url .= '?' . $url_data['query'];
		}
		if(isset($url_data['fragment'])) {
			$url .= '#' . $url_data['fragment'];
		}
		return $url;
	}	
	function mihouse_global_settings(){
		global $mihouse_settings;
		return $mihouse_settings;
	}
	if( !function_exists( 'mihouse_render_footer' ) ) :
	function mihouse_render_footer($footer_style){
		$elementor_instance = Elementor\Plugin::instance();
		return $elementor_instance->frontend->get_builder_content_for_display( $footer_style );
	}
	endif;	
	if ( ! function_exists( 'mihouse_popup_newsletter' ) ) {
		function mihouse_popup_newsletter() {
			$mihouse_settings = mihouse_global_settings(); 
			echo '<div class="popupshadow" style="display:none"></div>';
			echo '<div id="newsletterpopup" class="bingo-modal newsletterpopup" style="display:none">';
			echo '<span class="close-popup"><i class="zmdi zmdi-close"></i></span>';
			echo '<div class="wp-newletter"';
				if(isset($mihouse_settings['background_newletter_img']['url']) && !empty($mihouse_settings['background_newletter_img']['url'])){
					echo ' style="background:url('.esc_url($mihouse_settings['background_newletter_img']['url']).')"';
				}
			echo '>';	
				dynamic_sidebar('newletter-popup-form');
			echo '</div>';
			echo '</div>';
		}
	}	
	function mihouse_config_font(){
		$config_fonts = array();
		$text_fonts = array(
			'family_font_body',
			'family_font_custom',
			'h1-font',
			'h2-font',
			'h3-font',
			'h4-font',
			'h5-font',
			'h6-font',
			'class_font_custom'
		);
		foreach ($text_fonts as $text) {
			if(mihouse_get_config($text))
				$config_fonts[$text] = mihouse_get_config($text);
		}
		return $config_fonts;
	}
	function mihouse_get_class(){
		$class = new stdClass;
		$sidebar_left_expand 		= mihouse_get_config('sidebar_left_expand',3);
		$sidebar_left_expand_md 	= mihouse_get_config('sidebar_left_expand_md',3);
		$class->class_sidebar_left  = 'col-lg-'.$sidebar_left_expand.' col-md-'.$sidebar_left_expand_md.' col-sm-12 col-xs-12';
		$sidebar_right_expand 		= mihouse_get_config('sidebar_right_expand',3);
		$sidebar_right_expand_md 	= mihouse_get_config('sidebar_right_expand_md',3);
		$class->class_sidebar_right  = 'col-lg-'.$sidebar_right_expand.' col-md-'.$sidebar_right_expand_md.' col-sm-12 col-xs-12';
		$sidebar_blog = mihouse_blog_sidebar();
		if($sidebar_blog == 'left' && is_active_sidebar('sidebar-blog')){
			$blog_content_expand = 12- $sidebar_left_expand;
			$blog_content_expand_md = 12- $sidebar_left_expand_md;
		}elseif($sidebar_blog == 'right' && is_active_sidebar('sidebar-blog')){
			$blog_content_expand = 12- $sidebar_right_expand;
			$blog_content_expand_md = 12- $sidebar_right_expand_md;
		}else{
			$blog_content_expand = 12;
			$blog_content_expand_md = 12;
		}
		$class->class_blog_content  = 'col-lg-'.$blog_content_expand.' col-md-'.$blog_content_expand_md.' col-sm-12 col-xs-12';		
		$post_single_layout = mihouse_post_sidebar();
		if($post_single_layout == 'left' && is_active_sidebar('sidebar-blog')){
			$blog_single_expand = 12- $sidebar_left_expand;
			$blog_single_expand_md = 12- $sidebar_left_expand_md;
		}elseif($post_single_layout == 'right' && is_active_sidebar('sidebar-blog')){
			$blog_single_expand = 12- $sidebar_right_expand;
			$blog_single_expand_md = 12- $sidebar_right_expand_md;
		}else{
			$blog_single_expand = 12;
			$blog_single_expand_md = 12;
		}
		
		$apartment_single_layout = mihouse_apartment_sidebar();
		if($apartment_single_layout == 'left' && is_active_sidebar('sidebar-apartment')){
			$apartment_single_expand = 12- $sidebar_left_expand;
			$apartment_single_expand_md = 12- $sidebar_left_expand_md;
		}elseif($apartment_single_layout == 'right' && is_active_sidebar('sidebar-apartment')){
			$apartment_single_expand = 12- $sidebar_right_expand;
			$apartment_single_expand_md = 12- $sidebar_right_expand_md;
		}else{
			$apartment_single_expand = 12;
			$apartment_single_expand_md = 12;
		}
		$class->class_apartment_content  = 'col-lg-'.$apartment_single_expand.' col-md-'.$apartment_single_expand_md.' col-sm-12 col-xs-12';
		
		$class->class_single_content  = 'col-lg-'.$blog_single_expand.' col-md-'.$blog_single_expand_md.' col-sm-12 col-xs-12';
		$blog_col_large 	= 12/(mihouse_get_config('blog_col_large',3));
		$blog_col_medium = 12/(mihouse_get_config('blog_col_medium',3));
		$blog_col_sm 	= 12/(mihouse_get_config('blog_col_sm',3));
		$class->class_item_blog = 'col-lg-'.$blog_col_large.' col-md-'.$blog_col_medium.' col-sm-'.$blog_col_sm.' col-xs-12';		
		$apartment_col_large 	= 12/(mihouse_get_config('apartment_col_large',3));
		$apartment_col_medium = 12/(mihouse_get_config('apartment_col_medium',3));
		$apartment_col_sm 	= 12/(mihouse_get_config('apartment_col_sm',3));
		$class->class_item_apartment = 'col-lg-'.$apartment_col_large.' col-md-'.$apartment_col_medium.' col-sm-'.$apartment_col_sm.' col-xs-12';		
		return $class;
	}
	function mihouse_post_sidebar(){
		$sidebar_post = get_post_meta( get_the_ID(), 'post_single_layout', true );
		if( !empty($sidebar_post)){
			$post_single_layout = $sidebar_post;
		}else{
			$post_single_layout = mihouse_get_config('post-single-layout','left');
		}
		return 	$post_single_layout;
	}
	
	function mihouse_apartment_sidebar(){
		$sidebar_apartment = get_post_meta( get_the_ID(), 'apartment_single_layout', true );
		if( !empty($sidebar_apartment)){
			$apartment_single_layout = $sidebar_apartment;
		}else{
			$apartment_single_layout = mihouse_get_config('apartment-single-layout','left');
		}
		return 	$apartment_single_layout;
	}
	
	function mihouse_blog_view(){
		$category = get_category( get_query_var( 'cat' ) );
		$id_category =  ( isset($category->term_id) && $category->term_id ) ? $category->term_id : 0;
		$layout_blog = get_term_meta( $id_category, 'layout_blog', true );
		if( !empty($layout_blog) ){
			$blog_view = $layout_blog;
		}else{
			$blog_view = mihouse_get_config('layout_blog','list');
		}
		return 	$blog_view;
	}
	function mihouse_blog_sidebar(){
		$category = get_category( get_query_var( 'cat' ) );
		$id_category =  ( isset($category->term_id) && $category->term_id ) ? $category->term_id : 0;
		$sidebar_blog = get_term_meta( $id_category, 'sidebar_blog', true );
		if( !empty($sidebar_blog) ){
			$sidebar = $sidebar_blog;
		}else{
			$sidebar 		= mihouse_get_config('sidebar_blog','left');
		}
		return 	$sidebar;
	}	
	function mihouse_is_customize(){
		return isset($_POST['customized']) && ( isset($_POST['customize_messenger_chanel']) || isset($_POST['wp_customize']) );
	}	
	function mihouse_search_form_modify( $html ) {
		$form = '<form role="search" method="get" id="searchform" class="search-from" action="' . esc_url(home_url( '/' )) . '" >
					<input type="text" value="' . esc_attr(get_search_query()) . '" name="s"  class="s" placeholder="'.esc_attr__( 'Type here','mihouse' ).'" />
					<button id="searchsubmit" class="btn" type="submit">
						<i class="icofont icofont-search"></i>
						<span>' . esc_html__( 'Search', 'mihouse' ) . '</span>
					</button>
				</form>';
		return $form;
		// return str_replace( 'class="search-submit"', 'class="search-submit"', $html );
	}
	add_filter( 'get_search_form', 'mihouse_search_form_modify' );
	function mihouse_search_form() {
		$form = '<form role="search" method="get" id="searchform" class="search-from" action="' . esc_url(home_url( '/' )) . '" >
					<input type="text" value="' . esc_attr(get_search_query()) . '" name="s"  class="s" placeholder="'.esc_attr__( 'Type here','mihouse' ).'" />
					<button id="searchsubmit" class="btn" type="submit">
						<i class="icofont icofont-search"></i>
						<span>' . esc_html__( 'Search', 'mihouse' ) . '</span>
					</button>
				</form>';
		return $form;
	}	
	function mihouse_main_menu($id, $layout = "") {
		global $mihouse_settings, $post;
		$show_cart = $show_wishlist = false;
		if ( isset($mihouse_settings['show_cart']) ) {
		$show_cart            = $mihouse_settings['show_cart'];
		}
		if ( isset($mihouse_settings['show_wishlist']) ) {
		$show_wishlist            = $mihouse_settings['show_wishlist'];
		}
		$vertical_header_text = (isset($mihouse_settings['vertical_header_text']) && $mihouse_settings['vertical_header_text']) ? $mihouse_settings['vertical_header_text'] : '';
		$page_menu = $menu_output = $menu_full_output = $menu_with_search_output = $menu_float_output = $menu_vert_output = "";
		$main_menu_args = array(
			'echo'            => false,
			'theme_location' => 'main_navigation',
			'walker' => new mihouse_mega_menu_walker,
		);
		$menu_output .= '<nav id="'. esc_attr($id) .'" class="std-menu clearfix">'. "\n";
		if(function_exists('wp_nav_menu')) {
			if (has_nav_menu('main_navigation')) {
				$menu_output .= wp_nav_menu( $main_menu_args );
			}
			else {
				$menu_output .= '<div class="no-menu">'. esc_html__("Please assign a menu to the Main Menu in Appearance > Menus", 'mihouse').'</div>';
			}
		}
		$menu_output .= '</nav>'. "\n";
		switch ($layout) {
			case 'full':
					$menu_full_output .= '<div class="container">'. "\n";
					$menu_full_output .= '<div class="row">'. "\n";
					$menu_full_output .= '<div class="menu-left">'. "\n";
					$menu_full_output .= $menu_output . "\n";
					$menu_full_output .= '</div>'. "\n";
					$menu_full_output .= '<div class="menu-right">'. "\n";
					$menu_full_output .= '</div>'. "\n";
					$menu_full_output .= '</div>'. "\n";
					$menu_full_output .= '</div>'. "\n";
					$menu_output = $menu_full_output;
				break;
			case 'float':
					$menu_float_output .= '<div class="float-menu">'. "\n";
					$menu_float_output .= $menu_output . "\n";
					$menu_float_output .= '</div>'. "\n";
					$menu_output = $menu_float_output;
				break;
			case 'float-2':
					$menu_float_output .= '<div class="float-menu container">'. "\n";
					$menu_float_output .= $menu_output . "\n";
					$menu_float_output .= '</div>'. "\n";
					$menu_output = $menu_float_output;
				break;				
			case 'vertical':
				$menu_vertical_output .= $menu_output . "\n";
				$menu_vertical_output .= '<div class="vertical-menu-bottom">'. "\n";
				if($vertical_header_text)
				$menu_vertical_output .= '<div class="copyright">'.do_shortcode(stripslashes($vertical_header_text)).'</div>'. "\n";
				$menu_vertical_output .= '</div>'. "\n";
				$menu_output = $menu_vertical_output;
				break;
		}	
		return $menu_output;
	}				
	add_action('admin_enqueue_scripts','mihouse_upload_scripts');	
	function mihouse_upload_scripts()
    {
        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');
        wp_enqueue_style('thickbox');
    }		
	function mihouse_body_classes( $classes ) {
		if (is_single() || is_page() && !is_front_page()) {
			$classes[] = basename(get_permalink());
		}			
		$type_banner = mihouse_get_config('banners_effect');
		$classes[] = $type_banner;		
		$direction = mihouse_get_direction(); 
		if($direction && $direction == 'rtl'){
			$classes[] = 'rtl';
		}
		$box_layout 	= mihouse_get_config('layout');
		if( $box_layout == 'boxed' ){
			$classes[] = 'box-layout';
		}else{
			$classes[] = 'full-layout';
		}	
		return $classes;
	}
	add_filter( 'body_class', 'mihouse_body_classes' );
	function mihouse_post_classes( $classes ) {
		if ( ! post_password_required() && ! is_attachment() && has_post_thumbnail() ) {
			$classes[] = 'has-post-thumbnail';
		}
		return $classes;
	}
	add_filter( 'post_class', 'mihouse_post_classes' );
	function mihouse_wp_title( $title, $sep ) {
		global $paged, $page;
		if ( is_feed() ) {
			return $title;
		}
		// Add the site name.
		$title .= get_bloginfo( 'name', 'display' );
		// Add the site description for the home/front page.
		$site_description = get_bloginfo( 'description', 'display' );
		if ( $site_description && ( is_home() || is_front_page() ) ) {
			$title = "$title $sep $site_description";
		}
		// Add a page number if necessary.
		if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() ) {
			$title = "$title $sep " . sprintf( __( 'Page %s', 'mihouse' ), max( $paged, $page ) );
		}
		return $title;
	}
	add_filter( 'wp_title', 'mihouse_wp_title', 10, 2 );
	function mihouse_get_excerpt($limit = 45, $more_link = true, $more_style_block = false) {
		$mihouse_settings = mihouse_global_settings();
		if (!$limit) {
			$limit = 45;
		}
		if (has_excerpt()) {
			$content = get_the_excerpt();
		} else {
			$content = get_the_content();
		}
		if($content)
		{
			$content = mihouse_strip_tags( apply_filters( 'the_content', $content ) );
			$content = explode(' ', $content, $limit);
			if (count($content) >= $limit) {
				array_pop($content);
				$content = implode(" ",$content).'... ';
			} else {
				$content = implode(" ",$content);
			}
			$content = '<p class="post-excerpt">'.wp_kses_post($content).'</p>';
			if ($more_link) {
				if ($more_style_block) {
					$content .= ' <a class="read-more read-more-block" href="'.esc_url( apply_filters( 'the_permalink', get_permalink() ) ).'">'.esc_html__('Read more', 'mihouse').'</a>';
				} else {
					$content .= ' <a class="read-more" href="'.esc_url( apply_filters( 'the_permalink', get_permalink() ) ).'">'.esc_html__('Read more', 'mihouse').'</a>';
				}
			}
		}
		return $content;
	}
	function mihouse_strip_tags( $content ) {
		$content = str_replace( ']]>', ']]&gt;', $content );
		$content = preg_replace("/<script.*?\/script>/s", "", $content);
		$content = preg_replace("/<style.*?\/style>/s", "", $content);
		$content = strip_tags( $content );
		return $content;
	}
	if( !function_exists( 'mihouse_get_direction' ) ) :
	function mihouse_get_direction(){
		$direction = mihouse_get_config('direction','ltr');		
		if (isset($_COOKIE['mihouse_direction_cookie']))
			$direction = $_COOKIE['mihouse_direction_cookie'];
		if(isset($_GET['direction']) && $_GET['direction'])
			$direction = $_GET['direction'];
		return 	$direction;
	}
	endif;	
	function mihouse_get_entry_content_asset( $post_id ){
		$post = get_post( $post_id );
		$content = apply_filters ("the_content", $post->post_content);
		$video = get_media_embedded_in_content( $content, array( 'video', 'object', 'embed', 'iframe' ) );
		if ( ! empty( $video ) ) {
			$html = '';
			foreach ( $video as $video_html ) {
				$html .=   '<div class="video-wrapper">';
					$html .= $video_html;
				$html .= '</div>';
			}
			return $html;
		}
	}
	function mihouse_loading_overlay(){
		$mihouse_settings = mihouse_global_settings();
		if(isset($mihouse_settings['show-loading-overlay']) && $mihouse_settings['show-loading-overlay'] ){
			echo'<div class="loader-content">
				<div id="loader">
					<div class="chasing-dots"><div></div><div></div><div></div></div>
				</div>
			</div>';
		}
	}	
	function mihouse_category_post(){
		global $post;
		$obj_category = new stdClass;
		$term_list = wp_get_post_terms($post->ID,'category',array('fields'=>'ids'));
		$cat_id = (int)$term_list[0];
		$category = get_term( $cat_id, 'category' );
		$obj_category->name = $category->name;
		$obj_category->cat_link = get_term_link ($cat_id, 'category');	
		return $obj_category;
	}	
	function mihouse_header_logo(){
		$mihouse_settings = mihouse_global_settings(); 
		$sitelogo = (isset($mihouse_settings['sitelogo']['url']) && $mihouse_settings['sitelogo']['url']) ? $mihouse_settings['sitelogo']['url'] : "";
		$page_logo_url = get_post_meta( get_the_ID(), 'page_logo', true );
		$page_logo_url = ($page_logo_url) ? $page_logo_url : $sitelogo; ?>
		<div class="wpbingoLogo">
			<a  href="<?php echo esc_url( home_url( '/' ) ); ?>">
				<?php if($page_logo_url){ ?>
					<img src="<?php echo esc_url($page_logo_url); ?>" alt="<?php bloginfo('name'); ?>"/>
				<?php }else{
					$logo = get_template_directory_uri().'/images/logo/logo.png'; ?>
					<img src="<?php echo esc_attr( $logo ); ?>" alt="<?php bloginfo('name'); ?>"/>
				<?php } ?>
			</a>
		</div>
	<?php }
	function mihouse_top_menu(){
		$mihouse_settings = mihouse_global_settings();
		echo '<div class="wpbingo-menu-wrapper">
			<div class="megamenu">
				<nav class="navbar-default">
					<div class="navbar-header">
						<button type="button" id="show-megamenu"  class="navbar-toggle">
							<span>'. esc_html__("Menu","mihouse") .'</span>
						</button>
					</div>
					<div  class="bwp-navigation primary-navigation navbar-mega">
						'.mihouse_main_menu( 'main-navigation', 'float' ).'
					</div>
				</nav> 
			</div>       
		</div>';
	}	
	function mihouse_top_menu_right(){
		$mihouse_settings = mihouse_global_settings();
		echo '<div class="wpbingo-menu-wrapper">
			<div class="megamenu">
				<div  class="bwp-navigation primary-navigation navbar-mega">
					'.mihouse_main_menu( 'main-navigation', 'float' ).'
				</div>
			</div>       
		</div>';
	}
	function mihouse_copyright(){
		$mihouse_settings = mihouse_global_settings();?>
		<div class="bwp-copyright">
			<div class="container">		
			    <div class="row">
					<?php if(isset($mihouse_settings['footer-copyright']) && $mihouse_settings['footer-copyright']) : ?>		
						<div class="site-info col-sm-6 col-xs-12">
							<?php echo esc_html($mihouse_settings['footer-copyright']); ?>
						</div><!-- .site-info -->
					<?php else: ?>					
						<div class="site-info col-sm-6 col-xs-12">
							<?php echo esc_html__( 'Copyright 2019 ','mihouse'); ?>					
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html__('mihouse', 'mihouse'); ?></a>
							<?php echo esc_html__( 'Template. All Rights Reserved.','mihouse'); ?>
						</div><!-- .site-info -->		
					<?php endif; ?>
					<?php if(isset($mihouse_settings['footer-payments']) && $mihouse_settings['footer-payments']) : ?>
						<div class="payment col-sm-6 col-xs-12">
							<a href="<?php echo isset($mihouse_settings['footer-payments-link']) ? esc_url($mihouse_settings['footer-payments-link']) : "#"; ?>">
								<img src="<?php echo isset($mihouse_settings['footer-payments-image']['url']) ? esc_url($mihouse_settings['footer-payments-image']['url']) : ""; ?>" alt="<?php echo isset($mihouse_settings['footer-payments-image-alt']) ? esc_attr($mihouse_settings['footer-payments-image-alt']) : ""; ?>" />
							</a>
						</div>		
					<?php endif; ?>	
				</div>
			</div>
		</div>	
		<?php	
	}
	if( !is_admin() ){
		add_filter( 'language_attributes', 'mihouse_direction', 20 );
		function mihouse_direction( $doctype = 'html' ){
	   		$direction = mihouse_get_direction();
	   		if ( ( function_exists( 'is_rtl' ) && is_rtl() ) || $direction == 'rtl' ){
	    		$attribute[] = 'direction="rtl"';
	    		$attribute[] = 'class="rtl"';
	   		}
	   		( $direction === 'rtl' ) ? $lang = 'ar' : $lang = get_bloginfo('language');
	   		if ( $lang ) {
	   			if ( get_option('html_type') == 'text/html' || $doctype == 'html' )
	    			$attribute[] = "lang=\"$lang\"";
	   			if ( get_option('html_type') != 'text/html' || $doctype == 'xhtml' )
	    			$attribute[] = "xml:lang=\"$lang\"";
	   		}
	   		$mihouse_output = implode(' ', $attribute);
	   		return $mihouse_output;
		}
	}
	add_filter( 'woocommerce_enqueue_styles', '__return_false' );					
	function mihouse_woocommerce_breadcrumb( $args = array() ) {
		$args = wp_parse_args( $args, apply_filters( 'woocommerce_breadcrumb_defaults', array(
			'delimiter'   => '<span class="delimiter"></span>',
			'wrap_before' => '<div class="breadcrumb" ' . ( is_single() ? 'itemprop="breadcrumb"' : '' ) . '>',
			'wrap_after'  => '</div>',
			'before'      => '',
			'after'       => '',
			'home'        => _x( 'Home', 'breadcrumb', 'mihouse' )
		) ) );
		$breadcrumbs = new WC_Breadcrumb();
		if ( $args['home'] ) {
			$breadcrumbs->add_crumb( $args['home'], apply_filters( 'woocommerce_breadcrumb_home_url', home_url() ) );
		}
		$args['breadcrumb'] = $breadcrumbs->generate();
		wc_get_template( 'global/breadcrumb.php', $args );
	}
	function mihouse_walker_comment($comment, $args, $depth) {
		?>
            <div class="media">
                <div class="media-left">
                   <?php if ( $args['avatar_size'] != 0 ) echo get_avatar( $comment, 50 ); ?>
                </div>
                <div class="media-body">
                    <div class="media-content last">
						<div class="media-heading">
							<h4 class="media-title"><?php echo get_comment_author_link();?></h4>
							<span><?php printf( esc_html__('%1$s', 'mihouse' ), get_comment_date(),  get_comment_time() ); ?></span>
						</div>
                        <?php comment_text();?>
                        <?php 
							$args ['reply_text'] =  esc_html__( 'Reply', 'mihouse' );
							comment_reply_link( array_merge( $args, array(  'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); 
						?>
                    </div>
                </div>
            </div>
		<?php
	}
	add_filter('elementor/controls/animations/additional_animations', 'opal_add_animations_scroll');
	function opal_add_animations_scroll($animations) {
		$animations['Opal Animation'] = [
			'opal-move-up'    => 'Move Up',
		];
		return $animations;
	}
	if ( ! function_exists( 'wp_body_open' ) ) {
		function wp_body_open() {
			do_action( 'wp_body_open' );
		}
	}	
?>