<?php
if ( ! function_exists( 'mihouse_setup' ) ) :
		function mihouse_setup() {
			load_theme_textdomain( 'mihouse', get_template_directory() . '/languages' );
			// Add RSS feed links to <head> for posts and comments.
			add_theme_support( 'automatic-feed-links' );
			// Enable support for Post Thumbnails, and declare two sizes.
			add_theme_support( 'post-thumbnails' );
			set_post_thumbnail_size( 720, 484, true );
			add_image_size( 'mihouse-full-width', 1170, 771, true );
			add_image_size( 'mihouse-post-thumbnails', 1170, 395, true );
			add_image_size( 'mihouse-thumbnails-1', 680, 204, true );
			add_image_size( 'mihouse-thumbnails-hotspots', 50, 50, true );
			add_theme_support( 'title-tag' );
			/*
			 * Switch default core markup for search form, comment form, and comments
			 * to output valid HTML5.
			 */
			add_theme_support( 'html5', array(
				'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
			) );
			/*
			 * Enable support for Post Formats.
			 * See http://codex.wordpress.org/Post_Formats
			 */
			add_theme_support( 'post-formats', array(
				'aside', 'image', 'video', 'quote', 'link', 'gallery', 'status', 'audio', 'chat'
			) );
			// This theme allows users to set a custom background.
			add_theme_support( 'custom-background', apply_filters( 'mihouse_custom_background_args', array(
				'default-color' => 'f5f5f5',
			) ) );
			// Custom image header
			$mihouse_image_headers = array(
				'default-image' => get_template_directory_uri().'/images/logo/logo-default.png',
				'uploads'       => true
			);
			add_theme_support( 'custom-header', $mihouse_image_headers );
			// Tell the TinyMCE editor to use a custom stylesheet
			add_editor_style( 'css/editor-style.css' );
			// This theme uses its own gallery styles.
			add_filter( 'use_default_gallery_style', '__return_false' );
		}
		endif; // mihouse_setup
		add_action( 'after_setup_theme', 'mihouse_setup' );
		function mihouse_widgets_init() {
			register_sidebar( array(
				'name'          => esc_html__( 'Sidebar Blog', 'mihouse' ),
				'id'            => 'sidebar-blog',
				'description'   => esc_html__( 'Additional sidebar that appears on the right.', 'mihouse' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			) );
			register_sidebar( array(
				'name'          => esc_html__( 'Sidebar Apartment', 'mihouse' ),
				'id'            => 'sidebar-apartment',
				'description'   => esc_html__( 'Additional sidebar that appears on the right.', 'mihouse' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			) );
			register_sidebar( array(
				'name'          => esc_html__( 'Header Top Link', 'mihouse' ),
				'id'            => 'top-link',
				'description'   => esc_html__( 'Main sidebar that appears on the top.', 'mihouse' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			) );						
			register_sidebar( array(
				'name'          => esc_html__( 'Newsletter Popup', 'mihouse' ),
				'id'            => 'newletter-popup-form',
				'description'   => esc_html__( 'Appears in the content top section of the site.', 'mihouse' ),
				'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			) );
			register_sidebar( array(
				'name'          => esc_html__( 'Blog Post Right', 'mihouse' ),
				'id'            => 'blog-post-right',
				'description'   => esc_html__( 'Additional Blog Post that appears on the right.', 'mihouse' ),
				'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			) );
			register_sidebar( array(
				'name'          => esc_html__( 'Menu Categories', 'mihouse' ),
				'id'            => 'menu-categories',
				'description'   => esc_html__( 'Appears in the content top section of the site.', 'mihouse' ),
				'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			) );	
		}
		add_action( 'widgets_init', 'mihouse_widgets_init' );
		function mihouse_fonts_url() {
			$fonts_url = '';
			$prata = _x( 'on', 'Prata Serif font: on or off', 'mihouse' );
			$overpass = _x( 'on', 'Overpass Serif font: on or off', 'mihouse' );
			if ( 'off' !== $prata  || 'off' !== $overpass ) {
				$font_families = array();
				if ( 'off' !== $prata ) {
				$font_families[] = "Prata";
				}
				if ( 'off' !== $overpass ) {
				$font_families[] = 'Overpass:300,300i,400,400i,600,600i,700,700i,800,800i,900,900i';
				}
				$config_fonts = mihouse_config_font();
				foreach($config_fonts as $key => $selector_fonts){
					if(isset($selector_fonts['font-family']) && $selector_fonts['font-family']){
						$font = str_replace(" ","+",$selector_fonts['font-family']);
						$font_default=implode(",",$font_families);
						$pos = strpos($font_default, $font);
						if ($pos === false)
							$font_families[] =	$font;
					}
				} 
				$query_args = array(
					'family' =>	urlencode( implode( '|', $font_families ) ),
					'subset' =>	urlencode( 'latin,latin-ext' ),
				);
				$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
			}
			return esc_url_raw( $fonts_url );
		}
		function mihouse_scripts_styles() {
			wp_enqueue_style( 'mihouse-fonts', mihouse_fonts_url(), array(), null );
		}
		add_action( 'wp_enqueue_scripts', 'mihouse_scripts_styles' );	
		function mihouse_add_scripts() {
			// Load our main stylesheet.
			wp_enqueue_style( 'mihouse-style', get_stylesheet_uri() );
			// Load the Internet Explorer specific stylesheet.
			wp_enqueue_style( 'mihouse-ie', get_template_directory_uri() . '/css/ie.css', array( 'mihouse-style' ), '20131205' );
			wp_style_add_data( 'mihouse-ie', 'conditional', 'lt IE 9' );
			if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
				wp_enqueue_script( 'comment-reply' );
			}
			wp_enqueue_script( 'bootstrap',get_template_directory_uri().'/js/bootstrap.min.js', array('jquery'), null, true);
			wp_enqueue_script( 'mmenu-all',get_template_directory_uri().'/js/jquery.mmenu.all.min.js', array('jquery'), null, true);
			wp_enqueue_script( 'slick',get_template_directory_uri().'/js/slick.min.js',array('jquery'), null, true);
			wp_enqueue_script( 'instafeed',get_template_directory_uri().'/js/instafeed.min.js', array('jquery'), null, true);
			wp_enqueue_script( 'countdown',get_template_directory_uri().'/js/jquery.countdown.min.js', array('jquery'), null, true);
			wp_enqueue_script( 'fancybox', get_template_directory_uri().'/js/jquery.fancybox.min.js', array('jquery'), null, true);
			wp_enqueue_script( 'elevatezoom', get_template_directory_uri() . '/js/jquery.elevatezoom.js' , array('jquery'), null, true );
			wp_enqueue_script( 'swipebox', get_template_directory_uri() . '/js/jquery.swipebox.min.js' , array('jquery'), null, true );
			wp_enqueue_script( 'sticky-kit', get_template_directory_uri() . '/js/jquery.sticky-kit.min.js' , array('jquery'), null, true );	
			wp_enqueue_script( 'wc-quantity-increment', get_template_directory_uri().'/js/wc-quantity-increment.min.js', array('jquery'), null, true);
			wp_enqueue_script( 'isotopes', get_template_directory_uri().'/js/isotopes.js', array('jquery'), null, true);
			wp_register_script( 'jquery-cookie', get_template_directory_uri() . '/js/jquery.cookie.min.js', array( 'jquery' ), null, true );
			wp_enqueue_script( 'jquery-cookie' );
			wp_register_script( 'mihouse-newsletter', get_template_directory_uri() . '/js/newsletter.js', array('jquery','jquery-cookie'), null, true );
			wp_enqueue_script( 'mihouse-newsletter' );
			wp_enqueue_script( 'mihouse-script', get_template_directory_uri() . '/js/functions.js', array( 'jquery'), null, true );
			wp_enqueue_script( 'mihouse-script' );
			wp_register_script( 'mihouse-portfolio', get_template_directory_uri() . '/js/portfolio.js', array('jquery'), null, true );
			wp_enqueue_script( 'mihouse-portfolio' );
			$direction = mihouse_get_direction(); 
			if( is_rtl() || $direction == "rtl"){
				wp_enqueue_style( 'bootstrap-rtl',get_template_directory_uri().'/css/bootstrap-rtl.css' );
			}else{
				wp_enqueue_style( 'bootstrap', get_template_directory_uri().'/css/bootstrap.css' );
			}
			wp_enqueue_style('fancybox', get_template_directory_uri().'/css/jquery.fancybox.css', array(), null);
			wp_enqueue_style( 'mmenu-all', get_template_directory_uri().'/css/jquery.mmenu.all.css' );
			wp_enqueue_style('slick', get_template_directory_uri().'/css/slick/slick.css', array(), null);
			wp_enqueue_style( 'fontawesome',get_template_directory_uri().'/css/fontawesome.css' );
			wp_enqueue_style( 'icofont',get_template_directory_uri().'/css/icofont.css' );
			wp_enqueue_style( 'ionicons',get_template_directory_uri().'/css/ionicons.css' );
			wp_enqueue_style( 'materia',get_template_directory_uri().'/css/materia.css' );
			wp_enqueue_style( 'elegant',get_template_directory_uri().'/css/elegant.css' );	
		}
		add_action( 'wp_enqueue_scripts', 'mihouse_add_scripts' );
		function mihouse_admin_style() {
		  wp_enqueue_style('mihouse-admin-styles', get_template_directory_uri().'/inc/admin/css/options.css');
		}
		add_action('admin_enqueue_scripts', 'mihouse_admin_style');
		function mihouse_mime_types($mimes) {
			$mimes['svg'] = 'image/svg+xml';
			return $mimes;
		}
		add_filter('upload_mimes', 'mihouse_mime_types');
?>