<?php
if ( ! function_exists( 'mihouse_paging_nav' ) ) :
function mihouse_paging_nav() {
	global $wp_query, $wp_rewrite;
	// Don't print empty markup if there's only one page.
	if ( $wp_query->max_num_pages < 2 ) {
		return;
	}
	$paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
	$pagenum_link = html_entity_decode( get_pagenum_link() );
	$query_args   = array();
	$url_parts    = explode( '?', $pagenum_link );
	if ( isset( $url_parts[1] ) ) {
		wp_parse_str( $url_parts[1], $query_args );
	}
	$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
	$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';
	$format  = $wp_rewrite->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
	$format .= $wp_rewrite->using_permalinks() ? user_trailingslashit( $wp_rewrite->pagination_base . '/%#%', 'paged' ) : '?paged=%#%';
	// Set up paginated links.
	$pagination = paginate_links( array(
		'base'     => $pagenum_link,
		'format'   => $format,
		'total'    => $wp_query->max_num_pages,
		'current'  => $paged,
		'mid_size' => 1,
		'add_args' => array_map( 'urlencode', $query_args ),
		'prev_text' => esc_html__( 'Previous', 'mihouse' ),
		'next_text' => esc_html__( 'Next', 'mihouse' ),
		'type'      => 'list'
	) );
	if ( $pagination ) :
	?>
	<nav class="navigation paging-navigation" role="navigation">
		<h1 class="screen-reader-text"><?php esc_html_e( 'Posts navigation', 'mihouse' ); ?></h1>
		<div class="pagination loop-pagination">
			<?php echo wp_kses_post($pagination); ?>
		</div><!-- .pagination -->
	</nav><!-- .navigation -->
	<?php
	endif;
}
endif;
if ( ! function_exists( 'mihouse_post_nav' ) ) :
function mihouse_post_nav() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );
	$next_post = get_next_post();
	$previous_post = get_previous_post();
	if ( ! $next && ! $previous ) {
		return;
	}
	?>
	<div class="prevNextArticle box">
		<?php if($previous_post){ ?>
		<div class="previousArticle">
			<?php previous_post_link( '%link', '<div class="hoverExtend active"><i class="zmdi zmdi-arrow-left"></i></div>' ); ?>
		</div>
		<?php } ?>
		<?php if($next_post){ ?>
		<div class="nextArticle">
			<?php next_post_link( '%link', '<div class="hoverExtend active"><i class="zmdi zmdi-arrow-right"></i></div>' ); ?>
		</div>
		<?php } ?>
	</div><!-- Previous / next article -->
	<?php
}
endif;
if ( ! function_exists( 'mihouse_post_related' ) ) :
function mihouse_post_related() {
	global $post,$instance;
	$tags = wp_get_post_tags($post->ID);
	if ($tags) { ?>
				<?php $first_tag = $tags[0]->term_id;
				$limit = mihouse_get_config('related-limit',2);
				$args = array(
					'tag__in' => array($first_tag),
					'post__not_in' => array($post->ID),
					'posts_per_page'=>$limit,
					'caller_get_posts'=>1
				);
				$query = new WP_Query($args);				
				$columns 	= 12/(mihouse_get_config('related_col_large',2));
				$columns1 = 12/(mihouse_get_config('related_col_medium',2));
				$columns2 	= 12/(mihouse_get_config('related_col_sm',2));
				$columns = ($columns == 5) ? '2-4'  : (12/$columns);
				$columns1 = ($columns1 == 5) ? '2-4'  : (12/$columns1);
				$columns2 = ($columns2 == 5) ? '2-4'  : (12/$columns2);		
				if( $query->have_posts() ) { ?>
				<div class="post-related">
					<h3 class="title-related"><?php echo esc_html__('Latest post','mihouse'); ?></h3>
					<div class="content-related slick-carousel" data-columns3="12" data-columns2="<?php echo esc_attr($columns2); ?>" data-columns1="<?php echo esc_attr($columns1); ?>" data-columns="<?php echo esc_attr($columns); ?>">				
						<?php while ($query->have_posts()) : $query->the_post(); ?>
						<?php $format = get_post_format(); ?>
						<div id="post-<?php esc_attr(the_ID()); ?>" <?php post_class( 'post-grid' ); ?>>
							<div class="entry-post">
								<?php if( empty($format) || $format == 'image' || $format == 'quote') : ?>	
									<?php if ( get_the_post_thumbnail() ){?>
									<div class="entry-thumb single-thumb">
										<?php echo mihouse_time_link(); ?>
										<a class="post-thumbnail" href="<?php echo esc_url(the_permalink()); ?>" title="<?php the_title_attribute(); ?>">
											<?php
												if( has_post_thumbnail() ) :
													the_post_thumbnail( 'thumbnail', array( 'alt' => get_the_title() ) );
												else :
													echo '<img src="' . esc_url( get_template_directory_uri() . '/images/placeholder.jpg' ) . '" alt="' . the_title_attribute() . '">';
												endif;
											?>
										</a>
									</div>
									<?php } ?>
								<?php elseif( $format == 'video' || $format == 'audio' ) : ?>
									<div class="entry-thumb single-thumb">
										<?php echo mihouse_time_link(); ?>
										<a class="post-thumbnail" href="<?php esc_url(the_permalink()); ?>" title="<?php echo the_title_attribute(); ?>">
											<?php
												if( has_post_thumbnail() ) :
													the_post_thumbnail( 'thumbnail', array( 'alt' => get_the_title() ) );
												else :
													echo '<img src="' . esc_url( get_template_directory_uri() . '/images/placeholder.jpg' ) . '" alt="' . the_title_attribute() . '">';
												endif;
											?>
										</a> 
									</div>	
								<?php elseif( $format == 'gallery' ) : 
									$ids = "";	
									if(preg_match_all('/\[gallery(.*?)?\]/', get_post($instance['post_id'])->post_content, $matches)){
										$attrs = array();
											if (count($matches[1])>0){
												foreach ($matches[1] as $m){
													$attrs[] = shortcode_parse_atts($m);
												}
											}
											if (count($attrs)> 0){
												foreach ($attrs as $attr){
													if (is_array($attr) && array_key_exists('ids', $attr)){
														$ids = $attr['ids'];
														break;
													}
												}
											}
										?>
										<div class="entry-thumb">
											<?php echo mihouse_time_link(); ?>
											<div id="gallery_slider_<?php echo esc_attr($post->ID); ?>" class="gallery-slider">	
												<div class="slick-carousel" data-columns4="1" data-columns3="1" data-columns2="1" data-columns1="1" data-columns="1" data-nav="true">
														<?php
															if($ids){
																$ids = explode(',', $ids);						
																foreach ( $ids as $i => $id ){ ?>
																	<div class="item">	
																			<?php echo wp_get_attachment_image($id, array(270,270)); ?>
																	</div>
																<?php }	
															}
														?>
												</div>
											</div>
										</div>
										<?php }	?>			
									<?php endif; ?>
									<div class="post-content">
										<h3 class="entry-title"><a href="<?php echo esc_url(the_permalink()) ?>"><?php echo the_title(); ?></a></h3>
										<div class="entry-meta-head">
											<?php if( mihouse_category_post()){ ?>
											<div class="post-categories">
												<span><?php echo esc_html__('In ','mihouse');?></span>
												<a href="<?php echo esc_url(mihouse_category_post()->cat_link);?>"><?php echo esc_html(mihouse_category_post()->name); ?></a>
											</div>
											<?php } ?>
											<span class="entry-meta-link"><?php echo esc_html__('By ','mihouse'); ?><?php the_author_posts_link(); ?></span>
										</div>
										<?php
											if (mihouse_get_config('blog-excerpt')) {
												echo mihouse_get_excerpt( mihouse_get_config('grid-blog-excerpt-length',20), true);
											}
										?>
									</div>
							</div>	
						</div><!-- #post-## -->
						<?php endwhile; ?>
					</div>
				</div>					
		<?php } wp_reset_postdata(); ?>
	<?php }
}
endif;
function mihouse_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'mihouse_category_count' ) ) ) {
		// Create an array of all the categories that are attached to posts
		$all_the_cool_cats = get_categories( array(
			'hide_empty' => 1,
		) );
		// Count the number of categories that are attached to the posts
		$all_the_cool_cats = count( $all_the_cool_cats );
		set_transient( 'mihouse_category_count', $all_the_cool_cats );
	}
	if ( 1 !== (int) $all_the_cool_cats ) {
		return true;
	} else {
		return false;
	}
}
function mihouse_category_transient_flusher() {
	// Like, beat it. Dig?
	delete_transient( 'mihouse_category_count' );
}
add_action( 'edit_category', 'mihouse_category_transient_flusher' );
add_action( 'save_post',     'mihouse_category_transient_flusher' );
if ( ! function_exists( 'mihouse_post_thumbnail' ) ) :
function mihouse_post_thumbnail() {
	if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
		return;
	}
	if ( is_singular() ) : ?>
		<div class="post-thumbnail">
		<?php the_post_thumbnail( 'mihouse-full-width' ); ?>
		</div>
	<?php else : ?>
		<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
		<?php the_post_thumbnail( 'mihouse-full-width' ); ?>
		</a>
	<?php endif; // End is_singular()
}
endif;
function mihouse_page_title() {
	global $post, $mihouse_settings,$wp_query;
	$enable_page_title = isset($mihouse_settings['page_title']) ? $mihouse_settings['page_title'] : true ;
	if($enable_page_title){
		$bg = isset($mihouse_settings['page_title_bg']['url']) ? $mihouse_settings['page_title_bg']['url'] : "";
		$class_empty = (empty($bg)) ? " empty-image" : "";
		?>
		<div class="page-title bwp-title<?php echo esc_attr($class_empty); ?>" <?php echo (!empty($bg) ? ' style="background-image:url(' . esc_url( $bg ) . ');"' : ''); ?>>
			<div class="container" >
				<?php if(!is_single() ) :  ?>
					<h1><?php	if ( is_tax() ) :
									single_tag_title();	
								elseif ( is_category()) :					
									single_cat_title();
								elseif ( is_search() ) :
									printf( esc_html__( 'Search for: %s', 'mihouse' ), get_search_query() );							
								elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) :
									esc_html_e( 'Galleries', 'mihouse' );
								elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
									esc_html_e( 'Images', 'mihouse' );
								elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
									esc_html_e( 'Videos', 'mihouse' );
								elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
									esc_html_e( 'Quotes', 'mihouse' );
								elseif ( is_tax( 'post_format', 'post-format-audio' ) ) :
									esc_html_e( 'Audios', 'mihouse' );
								elseif (is_author() ) :
							esc_html_e( 'Posts by " ', 'mihouse' ) . the_author() . esc_html_e(' " ','mihouse');
						elseif ( is_archive() ) :
							echo the_archive_title();
						elseif ( is_404() ) :
							esc_html_e( '404 Error', 'mihouse' );
						elseif ( is_singular( 'knowledge' ) ) :
							esc_html_e( 'Knowledge Base', 'mihouse' );
						elseif ( is_home() ) :
							esc_html_e( 'Posts', 'mihouse' );
						else :
							echo get_the_title();
						endif;
						?>
					</h1>
				<?php endif; ?>
				<?php $enable_breadcrumb = isset($mihouse_settings['breadcrumb']) ? $mihouse_settings['breadcrumb'] : true ; ?>
				<?php if($enable_breadcrumb) : 
						get_template_part( 'breadcrumb');		
				endif; ?>
			</div><!-- .container -->
		</div><!-- Page Title -->
	<?php } ?>
<?php }
if ( ! function_exists( 'mihouse_single_posted_on' ) ) :
function mihouse_single_posted_on() { 
	global $mihouse_settings,$post; ?>
	<div class="entry-meta">
		<?php echo mihouse_time_link(); ?>
	</div>			
<?php }
endif;	
if ( ! function_exists( 'mihouse_posted_on' ) ) :
function mihouse_posted_on() { 
	global $mihouse_settings,$post; ?>
		<div class="post-meta">
			<div class="entry-info">
				<span class="entry-name"><?php echo esc_html__('By ','mihouse'); ?><?php the_author_posts_link(); ?></span>
				<?php echo mihouse_time_link1(); ?>
			</div>
		</div>		
<?php }
endif;
if ( ! function_exists( 'mihouse_time_link' ) ) :
	function mihouse_time_link() {
		$time_string = '<span class="entry-date"><time class="entry-date" datetime="%2$s"><span class="date">%3$s</span> %4$s</time></span>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<span class="entry-date"><time class="entry-date" datetime="%2$s"><span class="date">%3$s</span> %4$s</time></span>';
		}
		$time_string = sprintf(
			$time_string,
			get_the_date( DATE_W3C ),
			get_the_date('c'),
			get_the_date('d'),
			get_the_date('M'),
			get_the_date('Y'),
			get_the_date('g:i a'),
			get_the_modified_date( DATE_W3C ),
			get_the_modified_date()
		);
		return sprintf(
			__( '<span class="screen-reader-text">' . esc_html__('Posted on','mihouse'). '</span> %s', 'mihouse' ),
			'<a href="' . esc_url( get_permalink() ) . '" rel="mihouse">' . wp_kses_post($time_string) . '</a>'
		);
	}
endif;
if ( ! function_exists( 'mihouse_time_link1' ) ) :
	function mihouse_time_link1() {
		$time_string = '<span class="entry-date"><time class="entry-date" datetime="%6$s">%7$s</time></span>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<span class="entry-date"><time class="entry-date" datetime="%6$s">%7$s</time></span>';
		}
		$time_string = sprintf(
			$time_string,
			get_the_date( DATE_W3C ),
			get_the_date('l'),
			get_the_date('F j'),
			get_the_date('Y'),
			get_the_date('g:i a'),
			get_the_modified_date( DATE_W3C ),
			get_the_modified_date()
		);
		return sprintf(
			__( '<span class="screen-reader-text">' . esc_html__('Posted on','mihouse'). '</span> %s', 'mihouse' ),
			'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . wp_kses_post($time_string) . '</a>'
		);
	}
endif;
