/**
 * Theme functions file
 *
 * Contains handlers for navigation, accessibility, header sizing
 * footer widgets and Featured Content slider
 *
 */
( function( $ ) {
	"use strict";
	var _body    = $( 'body' ),
		_window = $( window );
	$(document).ready(function() {
		_sticky_menu();
		_left_right_submenu();
		_wpbGalleryreffect();
		// Search toggle.
		_search_toggle();
		/*Menu Categories*/
		_categories_menu_toggle();
		//Check to see if the window is top if not then display button
		_back_to_top();
		/* Add button show / hide for widget_product_categories */
		_toggle_categories();
		_layout_blog_masonry();
		_image_gallery_masonry();
		_load_wpbingo_menu_sidebar();
		_stickyContent();
		_click_button_layout();
		_load_video_popup();
		$( ".slick-carousel" ).each(function() {
			_load_slick_carousel($(this));	
		});
		_load_count_up();
	});
	_window.resize(function(){
		_load_canvas_menu();
		_wpbGalleryreffect();
		_left_right_submenu();
	});	
	/* Show/hide NewsLetter Popup */
	_window.load(function() {
		_body.addClass('loaded');
		_gridBlogMasonry();
	});
	function _toggle_categories(){
		var $root = $(".widget_product_categories");
		if($(".current-cat-parent",$root).length > 0){
			var $current_parent = $(".current-cat-parent",$root);
			$current_parent.addClass('open');
			$("> .children",$current_parent).stop().slideToggle(400);
		}
		var $current = $(".current-cat",$root);
		$current.addClass('open');
		$("> .children",$current).stop().slideToggle(400);
		$( '.cat-parent',$root ).each(function(index) {
				var $element = $(this);
				if($(".children",$element).length > 0){
				$element.prepend('<span class="arrow"></span>');
				$(".arrow",$element).on( 'click', function(e) {
					e.preventDefault();
					$element.toggleClass('open').find( '> .children' ).stop().slideToggle(400);
				});
			}
		});
	}	
	function _back_to_top(){
	   _window.scroll(function() {
			if ($(this).scrollTop() > 100) {
				$('.back-top').addClass('button-show');
			} else {
				$('.back-top').removeClass('button-show');
			}
		});
		$('.back-top').on( "click", function() {
			$('html, body').animate({
				scrollTop: 0
			}, 800);
			return false;
		});			
	}	
	function _categories_menu_toggle(){
		if($('.categories-menu .btn-categories').length){
			$('.categories-menu .btn-categories').on( "click", function(){
				$('.wrapper-categories').toggleClass('bwp-active');
			});
		}			
	}	
	function _search_toggle(){
		$( '.search-toggle' ).on( 'click.break', function( event ) {
			$('.page-wrapper').toggleClass('opacity-style');
			var wrapper = $( '.search-overlay' );
				wrapper.toggleClass( 'search-visible' );
		} );
		$( '.close-search','.search-overlay' ).on( 'click.break', function( event ) {
			$('.page-wrapper').toggleClass('opacity-style');
			var wrapper = $( '.search-overlay' );
				wrapper.toggleClass( 'search-visible');
		} );
	}	
	function _wpbingo_menu_left(){
		//Navigation Right
		var $header_wpbingo_menu_left = $('.header-wpbingo-menu-left');
		$('.wpbingo-menu-left .menu-title').on( "click", function() {
			if($header_wpbingo_menu_left.hasClass('active')){
				$header_wpbingo_menu_left.removeClass('active');
			}	
			else{
				$header_wpbingo_menu_left.addClass('active');
			}	
			return false;
		});			
	}
	_wpbingo_menu_left();
	function _show_sticky_sidebar(){
		var $sticky_sidebar = $('.sticky-sidebar');
		$('.btn-sticky').on( "click", function() {
			if($sticky_sidebar.hasClass('active')){
				$sticky_sidebar.removeClass('active');
			}	
			else{
				$sticky_sidebar.addClass('active');
			}	
			return false;
		});			
	}
	_show_sticky_sidebar();	
	function _headercategories(){
		//Navigation right
		var $menu_categories = $('.menu-categories');
		$('.navigation-categories').on( "click", function() {
			if($menu_categories.hasClass('active')){
				$menu_categories.removeClass('active');
			}	
			else{
				$menu_categories.addClass('active');
			}	
			return false;
		});		
		$('.mihouse-close',$menu_categories).on( "click", function() {
			$menu_categories.removeClass('active');
			return false;
		});		
		//Navigation right			
	}
	 _headercategories();
	function _canvasrightNavigation(){
		//Navigation right
		var $wpbingo_menu_right = $('.wpbingo-menu-right');
		$('.menu-title-box').on( "click", function() {
			if($wpbingo_menu_right.hasClass('active')){
				$wpbingo_menu_right.removeClass('active');
			}	
			else{
				$wpbingo_menu_right.addClass('active');
			}	
			return false;
		});		
		$('.mihouse-close',$wpbingo_menu_right).on( "click", function() {
			$wpbingo_menu_right.removeClass('active');
			return false;
		});		
		//Navigation right			
	}
	 _canvasrightNavigation();
	function _canvasleftNavigation(){
		//Navigation left
		var $wpbingo_menu_right = $('.header-content');
		$('.menu-title-box').on( "click", function() {
			if($wpbingo_menu_right.hasClass('active')){
				$wpbingo_menu_right.removeClass('active');
			}	
			else{
				$wpbingo_menu_right.addClass('active');
			}	
			return false;
		});			
		//Navigation left			
	}
	 _canvasleftNavigation();
	function _setGetParameter(paramName, paramValue)
	{
		var url = window.location.href;
		var hash = location.hash;
		url = url.replace(hash, '');
		if (url.indexOf(paramName + "=") >= 0)
		{
			var prefix = url.substring(0, url.indexOf(paramName));
			var suffix = url.substring(url.indexOf(paramName));
			suffix = suffix.substring(suffix.indexOf("=") + 1);
			suffix = (suffix.indexOf("&") >= 0) ? suffix.substring(suffix.indexOf("&")) : "";
			url = prefix + paramName + "=" + paramValue + suffix;
		}
		else
		{
		if (url.indexOf("?") < 0)
			url += "?" + paramName + "=" + paramValue;
		else
			url += "&" + paramName + "=" + paramValue;
		}
		window.location.href = url + hash;
	}
	function _sticky_menu(){
		if(_window.width() >= 1024){
			if($(".header-content").data("sticky_header")){
				var CurrentScroll = 0;
				var bwp_width = _window.width();
				_window.scroll(function() {
				if(($(".header-content").data("sticky_tablet") == 0) && bwp_width < 992)
					return;
				var NextScroll = $(this).scrollTop();
				if ((NextScroll < CurrentScroll) && NextScroll > 200) {
					$('.bwp-header').addClass('sticky');
				} else if (NextScroll >= CurrentScroll ||  NextScroll <=200 ) {
					$('.bwp-header').removeClass('sticky');
				}
				CurrentScroll = NextScroll;  
				});
			}
		}	
	}	
	function _mihouse_top_link(){
		var custom_menu = $('.block-top-link .widget-custom-menu');
		$('.widget-title',custom_menu).on( "click", function(){
			if($(this).hasClass('active')){
				$(this).removeClass('active');
				$('div',$(this).parent()).slideUp();	
			}
			else{
				$('.widget-title',custom_menu).removeClass('active');
				$('div',custom_menu).slideUp();				
				$(this).addClass('active');
				$('div',$(this).parent()).slideDown();	
			}	
		});
	}
	_mihouse_top_link();
	function _load_slick_carousel($element){
		$element.slick({
			arrows: $element.data("nav") ? true : false ,
			dots: $element.data("dots") ? true : false ,
			prevArrow: '<i class="slick-arrow zmdi zmdi-chevron-left"></i>',
			nextArrow: '<i class="slick-arrow zmdi zmdi-chevron-right"></i>',	
			slidesToShow: $element.data("columns"),
			asNavFor: $element.data("asnavfor") ? $element.data("asnavfor") : false ,
			vertical: $element.data("vertical") ? true : false ,
			verticalSwiping: $element.data("verticalswiping") ? $element.data("verticalswiping") : false ,
			rtl: (_body.hasClass("rtl") && !$element.data("vertical")) ? true : false ,
			centerMode: $element.data("centermode") ? $element.data("centermode") : false ,
			centerPadding: $element.data("centerpadding") ? $element.data("centerpadding") : false ,
			focusOnSelect: $element.data("focusonselect") ? $element.data("focusonselect") : false ,
			responsive: [	
				{
				  breakpoint: 1200,
				  settings: {
					slidesToShow: $element.data("columns1"),
				  }
				},				
				{
				  breakpoint: 1024,
				  settings: {
					slidesToShow: $element.data("columns2"),
					centerMode : false
				  }
				},
				{
				  breakpoint: 768,
				  settings: {
					slidesToShow: $element.data("columns3"),
					vertical: false,
					verticalSwiping : false,
					centerMode : false
				  }
				},
				{
				  breakpoint: 480,			  
				  settings: {
					slidesToShow: $element.data("columns4"),
					vertical: false,
					verticalSwiping : false,
					centerMode : false					
				  }
				}
			],
			onAfterChange: function() {
				_move_nav_slick($element);
			}			
		});
		_move_nav_slick($element);
	}
	function _move_nav_slick($element){
		if($(".slick-arrow",$element).length > 0){
			var $prev = $(".zmdi-chevron-left",$element).clone();
			$(".zmdi-chevron-left",$element).remove();
			if($element.parent().find(".zmdi-chevron-left").length == 0){
				$prev.prependTo($element.parent());
			}
			$prev.on( "click", function() {
				$element.slickPrev();
			});
			var $next =  $(".zmdi-chevron-right",$element).clone();
			$(".zmdi-chevron-right",$element).remove();
			if($element.parent().find(".zmdi-chevron-right").length == 0){
				$next.appendTo($element.parent());
			}
			$next.on( "click", function() {
				$element.slickNext();
			});
		}		
	}	
	//Dropdown Menu
	function _dropdown_menu(){
		$( ".pwb-dropdown" ).each(function(){
			var $dropdown = $(this);
			var active_text = $dropdown.find('li.active').text();
			if(active_text){
				$(".pwb-dropdown-toggle",$dropdown).html(active_text);
			}
			$("li",$dropdown).on( "click", function() {
				$("li",$dropdown).removeClass("active");
				$(this).addClass('active');
				var this_text = $(this).text();
				$(".pwb-dropdown-toggle",$dropdown).html(this_text);
				$dropdown.removeClass("open");
			});
		});		
	}
	_dropdown_menu();
	//Menu CanVas
	function _click_button_canvas_menu(){
		$('#show-megamenu').on( "click", function() {
			if($('.bwp-canvas-navigation').hasClass('active'))
				$('.bwp-canvas-navigation').removeClass('active');
			else
				$('.bwp-canvas-navigation').addClass('active');
			return false;
		});		
	}
	_click_button_canvas_menu();
	function _load_canvas_menu(){
		var wd_width = _window.width(); 
		var $main_menu = $(".menu","#main-navigation");
		if(wd_width <= 991){
			if($("#canvas-main-menu").length < 1 && $main_menu.length > 0){
				var $menu = $main_menu.parent().clone();
				$menu.attr( "id", "canvas-main-menu");
				$($menu).find(".menu").removeAttr('id');
				$('#page').append('<div  class="bwp-canvas-navigation"><span id="remove-megamenu" class="remove-megamenu icon-remove"></span></div>');			
				$('.bwp-canvas-navigation').append($menu);
				$menu.mmenu({
					offCanvas: false,
					"navbar": {
					"title": false
					}
				});
				_remove_canvas_menu();
			}
		}else{
			$(".bwp-canvas-navigation").remove();
		}		
	}
	_load_canvas_menu();
	function _remove_canvas_menu(){
		$('#remove-megamenu').on( "click", function() {
			$('.bwp-canvas-navigation').removeClass('active');
			return false;
		});		
	}
	function _layout_blog_masonry(){
		var $container = $(".blog-content-masonry");
		$container.imagesLoaded().progress( function() {
			$container.isotope({
				layoutMode : "masonry",
				percentPosition: true,
				masonry: {
				  columnWidth: ".masonry-post"
				}
			});
		});
	}
	function _image_gallery_masonry(){
		$( ".bwp-tab-gallery" ).each(function(){
			var $element = $(this);
			var $grid = $('.grid',$element).isotope({
				itemSelector: '.element-item',
				layoutMode: 'fitRows'
			});
			$('.filters-button-group',$element).on( 'click', 'button', function() {
				var filterValue = $( this ).attr('data-filter');
				$grid.isotope({ filter: filterValue });
			});
			$('.button-group',$element).each( function( i, buttonGroup ) {
				var $buttonGroup = $( buttonGroup );
				$buttonGroup.on( 'click', 'button', function() {
					$buttonGroup.find('.is-checked').removeClass('is-checked');
					$( this ).addClass('is-checked');
				});
			});
		});
	}	
	function _load_wpbingo_menu_sidebar(){
		var $menu = $(".wpbingo-menu-sidebar");
		var $menu_2 = $(".wpbingo-menu-right");
		var $menu_3 = $(".wpbingo-menu-left");
		appendGrower($menu);
		appendGrower($menu_2);
		appendGrower($menu_3);
	}	
	function appendGrower($menu)
	{
		if($("li.menu-item-has-children",$menu).find('.grower').length <= 0){
			$("li.menu-item-has-children",$menu).append('<span class="grower close"> </span>');
			clickGrower($menu);
		}	
	}
	function removeGrower($menu)
	{
		$(".grower",$menu).remove();
	}
	function offtogglemegamenu($menu)
	{
		$('li.menu-item-has-children .sub-menu',$menu).css('display','');	
		$menu.removeClass('active');
		$("li.menu-item-has-children  .grower",$menu).removeClass('open').addClass('close');	
	}	
	function clickGrower($menu){
		$("li.menu-item-has-children  .grower",$menu).on( "click", function() {
			if($(this).hasClass('close')){
				$(this).addClass('open').removeClass('close');
				$('.sub-menu',$(this).parent()).first().slideDown();	
			}else{
				$(this).addClass('close').removeClass('open');		
				$('.sub-menu',$(this).parent()).first().slideUp();
			}
		});			
	}
	function _click_button_menu(){
		$('.header-center').on( "click", function() {
			if($('.header-content').hasClass('active'))
				$('.header-content').removeClass('active');
			else
				$('.header-content').addClass('active');
			return false;
		});		
	}
	_click_button_menu();
	
	function _click_button_layout(){
		$('.button-map').on( "click", function() {
			if($('.google-map').hasClass('active'))
				$('.google-map').removeClass('active');
			else
				$('.google-map').addClass('active');
			return false;
		});
		_window.on( "click", function() {
			if($('.google-map').hasClass('active')){
				$('.google-map').removeClass('active');
			}
		});
	}
	function _stickyContent(){
		var $element = $(".bwp-recent-post.sticky-post");
		_window.scroll(function() {
			if ($(this).scrollTop() > 50) {
			   $element.addClass("active");
			} else {
			   $element.removeClass("active");
			}
		});
	}
	function _gridBlogMasonry(){	
		var $element = $(".layout_masonry");
		$element.each(function(){
			$('.content-masonry',$(this)).isotope({
				itemSelector: '.post-grid',
				columnWidth: '.post-grid',
				percentPosition: true,
				initLayout: false
			});	
		});
	}
	function _left_right_submenu(){
		$( ".menu-item-has-children.level-1" ).each(function() {
			var _item_menu = $(this);
			var spacing_item_menu = _item_menu.outerWidth();
			var spacing_item_menu_left = _item_menu.offset().left;
			var spacing_item_menu_right = _window.width() - (spacing_item_menu+spacing_item_menu_left);
			if(spacing_item_menu_right <= 225){
				_item_menu.addClass("sub-menu-left");
			}else{
				_item_menu.removeClass("sub-menu-left");
			}	
		});
	}
	function _wpbGalleryreffect(){
		const nodes = [].slice.call(document.querySelectorAll('.gallery-icon'), 0);
		const directions  = { 0: 'top', 1: 'right', 2: 'bottom', 3: 'left' };
		const classNames = ['in', 'out'].map((p) => Object.values(directions).map((d) => `${p}-${d}`)).reduce((a, b) => a.concat(b));

		const getDirectionKey = (ev, node) => {
		  const { width, height, top, left } = node.getBoundingClientRect();
		  const l = ev.pageX - (left + window.pageXOffset);
		  const t = ev.pageY - (top + window.pageYOffset);
		  const x = (l - (width/2) * (width > height ? (height/width) : 1));
		  const y = (t - (height/2) * (height > width ? (width/height) : 1));
		  return Math.round(Math.atan2(y, x) / 1.57079633 + 5) % 4;
		}

		class Item {
		  constructor(element) {
			this.element = element;    
			this.element.addEventListener('mouseover', (ev) => this.update(ev, 'in'));
			this.element.addEventListener('mouseout', (ev) => this.update(ev, 'out'));
		  }
		  
		  update(ev, prefix) {
			this.element.classList.remove(...classNames);
			this.element.classList.add(`${prefix}-${directions[getDirectionKey(ev, this.element)]}`);
		  }
		}

		nodes.forEach(node => new Item(node));
	}
	function _load_video_popup(){
		$(".bwp-video").on( "click", function(){
			$.fancybox({
				'padding'		: 0,
				'href'			: $(this).attr("href").replace(new RegExp("watch\\?v=", "i"), 'v/'),
				'type'			: 'swf'
			});
			return false;	
		});
	}
	function _load_count_up(){
		var a = 0;
		if($('.bwp-cta').length > 0 ){
			_window.scroll(function() {
				var oTop = $('.bwp-cta').offset().top - window.innerHeight;
				if(a == 0 && _window.scrollTop() > oTop){
					$('.count-cta').each(function () {
						$(this).prop('Counter',0).animate({
							Counter: $(this).text()
						}, {
							duration: 2000,
							easing: 'swing',
							step: function (now) {
								$(this).text(Math.ceil(now));
							}
						});
					});
					a = 1;
				}
			});
		}
	}
} )( jQuery );