<?php 
	$mihouse_settings = mihouse_global_settings();
	$enable_sticky_header = ( isset($mihouse_settings['enable-sticky-header']) && $mihouse_settings['enable-sticky-header'] ) ? ($mihouse_settings['enable-sticky-header']) : false;
	$show_searchform = (isset($mihouse_settings['show-searchform']) && $mihouse_settings['show-searchform']) ? ($mihouse_settings['show-searchform']) : false;
?>
<h1 class="bwp-title hide"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
<header id='bwp-header' class="bwp-header header-v1">
	<div class='header-wrapper '>
		<div class='header-content' data-sticky_header="<?php echo esc_attr($enable_sticky_header); ?>">
			<div class="header-logo">
				<?php mihouse_header_logo(); ?>
			</div>
			<div class="header-menu">
				<div class="header-right-default">
					<div class="wpbingo-menu-mobile">
						<?php mihouse_top_menu(); ?>
					</div>
				</div>
			</div>
			<div class="header-right hidden-xs">
				<?php if( isset($mihouse_settings['phone']) && $mihouse_settings['phone'] ) : ?>
					<div class="phone hidden-md hidden-sm hidden-xs"><a href="tel:<?php echo esc_attr($mihouse_settings['phone']); ?>"><?php echo esc_html($mihouse_settings['phone']); ?></a></div>
				<?php endif; ?>
				<?php if( isset($mihouse_settings['mail']) && $mihouse_settings['mail'] ) : ?>
					<div class="email hidden-md hidden-sm hidden-xs"><a href="mailto:<?php echo esc_attr($mihouse_settings['mail']); ?>"><?php echo esc_html($mihouse_settings['mail']); ?></a></div>
				<?php endif; ?>
				<?php if((isset($mihouse_settings['show-newletter']) && $mihouse_settings['show-newletter']) && is_active_sidebar('newletter-popup-form')) : ?>		
					<div class="btn-newletter"><?php echo esc_html__('Schedule a visit','mihouse'); ?></div>
				<?php endif;  ?>
			</div>
		</div>
	</div><!-- End header-wrapper -->
</header><!-- End #bwp-header -->