<?php 
	$mihouse_settings = mihouse_global_settings();
	$enable_sticky_header = ( isset($mihouse_settings['enable-sticky-header']) && $mihouse_settings['enable-sticky-header'] ) ? ($mihouse_settings['enable-sticky-header']) : false;
?>
<h1 class="bwp-title hide"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
<header id='bwp-header' class="bwp-header header-v5">
	<div class='header-wrapper '>
		<div class='header-content'>
			<div class="wpbingo-menu-left">
				<div class="wpbingo-menu-mobile">
					<?php mihouse_top_menu_right(); ?>
				</div>
				<div class="header-info">
					<?php if( isset($mihouse_settings['phone']) && $mihouse_settings['phone'] ) : ?>
						<div class="phone "><a href="tel:<?php echo esc_attr($mihouse_settings['phone']); ?>"><?php echo esc_html($mihouse_settings['phone']); ?></a></div>
					<?php endif; ?>
					<?php if( isset($mihouse_settings['mail']) && $mihouse_settings['mail'] ) : ?>
						<div class="email"><a href="mailto:<?php echo esc_attr($mihouse_settings['mail']); ?>"><?php echo esc_html($mihouse_settings['mail']); ?></a></div>
					<?php endif; ?>
					<?php if((isset($mihouse_settings['show-newletter']) && $mihouse_settings['show-newletter']) && is_active_sidebar('newletter-popup-form')) : ?>		
						<div class="btn-newletter"><?php echo esc_html__('Schedule a visit','mihouse'); ?></div>
					<?php endif;  ?>
				</div>
			</div>
			<div class="header-top">
				<div class="header-logo">
					<div class="header-logo">
						<?php mihouse_header_logo(); ?>
					</div>
				</div>
			</div>
			<div class="header-center">
				<div class="menu-title-box">
					<button type="button" class="navbar-toggle menu-title">
						<span class="icon-bar top-bar"></span>
						<span class="icon-bar middle-bar"></span>
						<span class="icon-bar bottom-bar"></span>
					</button>    			
				</div>
			</div>
			<div class="header-bottom">
				<div class="menu-title-box-bottom">
					<button type="button" class="navbar">
						<span></span>
						<span></span>
						<span></span>
						<span></span>
						<span></span>
						<span></span>
					</button>    			
				</div>
			</div>
		</div>
	</div><!-- End header-wrapper -->
</header><!-- End #bwp-header -->